/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic.lucene;

import java.util.BitSet;
import java.util.IdentityHashMap;
import org.carrot2.text.linguistic.lucene.StemmerUtil;

class IndicNormalizer {
    private static final IdentityHashMap<Character.UnicodeBlock, ScriptData> scripts = new IdentityHashMap(9);
    private static final int[][] decompositions;

    static {
        scripts.put(Character.UnicodeBlock.DEVANAGARI, new ScriptData(1, 2304));
        scripts.put(Character.UnicodeBlock.BENGALI, new ScriptData(2, 2432));
        scripts.put(Character.UnicodeBlock.GURMUKHI, new ScriptData(4, 2560));
        scripts.put(Character.UnicodeBlock.GUJARATI, new ScriptData(8, 2688));
        scripts.put(Character.UnicodeBlock.ORIYA, new ScriptData(16, 2816));
        scripts.put(Character.UnicodeBlock.TAMIL, new ScriptData(32, 2944));
        scripts.put(Character.UnicodeBlock.TELUGU, new ScriptData(64, 3072));
        scripts.put(Character.UnicodeBlock.KANNADA, new ScriptData(128, 3200));
        scripts.put(Character.UnicodeBlock.MALAYALAM, new ScriptData(256, 3328));
        decompositions = new int[][]{{5, 62, 69, 17, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.GUJARATI)}, {5, 62, 70, 18, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI)}, {5, 62, 71, 19, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.GUJARATI)}, {5, 62, 72, 20, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.GUJARATI)}, {5, 62, -1, 6, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.BENGALI) | IndicNormalizer.flag(Character.UnicodeBlock.GURMUKHI) | IndicNormalizer.flag(Character.UnicodeBlock.GUJARATI) | IndicNormalizer.flag(Character.UnicodeBlock.ORIYA)}, {5, 69, -1, 114, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI)}, {5, 69, -1, 13, IndicNormalizer.flag(Character.UnicodeBlock.GUJARATI)}, {5, 70, -1, 4, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI)}, {5, 71, -1, 15, IndicNormalizer.flag(Character.UnicodeBlock.GUJARATI)}, {5, 72, -1, 16, IndicNormalizer.flag(Character.UnicodeBlock.GURMUKHI) | IndicNormalizer.flag(Character.UnicodeBlock.GUJARATI)}, {5, 73, -1, 17, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.GUJARATI)}, {5, 74, -1, 18, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI)}, {5, 75, -1, 19, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.GUJARATI)}, {5, 76, -1, 20, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.GURMUKHI) | IndicNormalizer.flag(Character.UnicodeBlock.GUJARATI)}, {6, 69, -1, 17, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.GUJARATI)}, {6, 70, -1, 18, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI)}, {6, 71, -1, 19, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.GUJARATI)}, {6, 72, -1, 20, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.GUJARATI)}, {7, 87, -1, 8, IndicNormalizer.flag(Character.UnicodeBlock.MALAYALAM)}, {9, 65, -1, 10, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI)}, {9, 87, -1, 10, IndicNormalizer.flag(Character.UnicodeBlock.TAMIL) | IndicNormalizer.flag(Character.UnicodeBlock.MALAYALAM)}, {14, 70, -1, 16, IndicNormalizer.flag(Character.UnicodeBlock.MALAYALAM)}, {15, 69, -1, 13, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI)}, {15, 70, -1, 14, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI)}, {15, 71, -1, 16, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI)}, {15, 87, -1, 16, IndicNormalizer.flag(Character.UnicodeBlock.ORIYA)}, {18, 62, -1, 19, IndicNormalizer.flag(Character.UnicodeBlock.MALAYALAM)}, {18, 76, -1, 20, IndicNormalizer.flag(Character.UnicodeBlock.TELUGU) | IndicNormalizer.flag(Character.UnicodeBlock.KANNADA)}, {18, 85, -1, 19, IndicNormalizer.flag(Character.UnicodeBlock.TELUGU)}, {18, 87, -1, 20, IndicNormalizer.flag(Character.UnicodeBlock.TAMIL) | IndicNormalizer.flag(Character.UnicodeBlock.MALAYALAM)}, {19, 87, -1, 20, IndicNormalizer.flag(Character.UnicodeBlock.ORIYA)}, {21, 60, -1, 88, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI)}, {22, 60, -1, 89, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.GURMUKHI)}, {23, 60, -1, 90, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.GURMUKHI)}, {28, 60, -1, 91, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.GURMUKHI)}, {33, 60, -1, 92, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.BENGALI) | IndicNormalizer.flag(Character.UnicodeBlock.ORIYA)}, {34, 60, -1, 93, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.BENGALI) | IndicNormalizer.flag(Character.UnicodeBlock.ORIYA)}, {35, 77, 255, 122, IndicNormalizer.flag(Character.UnicodeBlock.MALAYALAM)}, {36, 77, 255, 78, IndicNormalizer.flag(Character.UnicodeBlock.BENGALI)}, {40, 60, -1, 41, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI)}, {40, 77, 255, 123, IndicNormalizer.flag(Character.UnicodeBlock.MALAYALAM)}, {43, 60, -1, 94, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.GURMUKHI)}, {47, 60, -1, 95, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.BENGALI)}, {44, 65, 65, 11, IndicNormalizer.flag(Character.UnicodeBlock.TELUGU)}, {48, 60, -1, 49, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI)}, {48, 77, 255, 124, IndicNormalizer.flag(Character.UnicodeBlock.MALAYALAM)}, {50, 77, 255, 125, IndicNormalizer.flag(Character.UnicodeBlock.MALAYALAM)}, {51, 60, -1, 52, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI)}, {51, 77, 255, 126, IndicNormalizer.flag(Character.UnicodeBlock.MALAYALAM)}, {53, 65, -1, 46, IndicNormalizer.flag(Character.UnicodeBlock.TELUGU)}, {62, 69, -1, 73, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.GUJARATI)}, {62, 70, -1, 74, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI)}, {62, 71, -1, 75, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.GUJARATI)}, {62, 72, -1, 76, IndicNormalizer.flag(Character.UnicodeBlock.DEVANAGARI) | IndicNormalizer.flag(Character.UnicodeBlock.GUJARATI)}, {63, 85, -1, 64, IndicNormalizer.flag(Character.UnicodeBlock.KANNADA)}, {65, 65, -1, 66, IndicNormalizer.flag(Character.UnicodeBlock.GURMUKHI)}, {70, 62, -1, 74, IndicNormalizer.flag(Character.UnicodeBlock.TAMIL) | IndicNormalizer.flag(Character.UnicodeBlock.MALAYALAM)}, {70, 66, 85, 75, IndicNormalizer.flag(Character.UnicodeBlock.KANNADA)}, {70, 66, -1, 74, IndicNormalizer.flag(Character.UnicodeBlock.KANNADA)}, {70, 70, -1, 72, IndicNormalizer.flag(Character.UnicodeBlock.MALAYALAM)}, {70, 85, -1, 71, IndicNormalizer.flag(Character.UnicodeBlock.TELUGU) | IndicNormalizer.flag(Character.UnicodeBlock.KANNADA)}, {70, 86, -1, 72, IndicNormalizer.flag(Character.UnicodeBlock.TELUGU) | IndicNormalizer.flag(Character.UnicodeBlock.KANNADA)}, {70, 87, -1, 76, IndicNormalizer.flag(Character.UnicodeBlock.TAMIL) | IndicNormalizer.flag(Character.UnicodeBlock.MALAYALAM)}, {71, 62, -1, 75, IndicNormalizer.flag(Character.UnicodeBlock.BENGALI) | IndicNormalizer.flag(Character.UnicodeBlock.ORIYA) | IndicNormalizer.flag(Character.UnicodeBlock.TAMIL) | IndicNormalizer.flag(Character.UnicodeBlock.MALAYALAM)}, {71, 87, -1, 76, IndicNormalizer.flag(Character.UnicodeBlock.BENGALI) | IndicNormalizer.flag(Character.UnicodeBlock.ORIYA)}, {74, 85, -1, 75, IndicNormalizer.flag(Character.UnicodeBlock.KANNADA)}, {114, 63, -1, 7, IndicNormalizer.flag(Character.UnicodeBlock.GURMUKHI)}, {114, 64, -1, 8, IndicNormalizer.flag(Character.UnicodeBlock.GURMUKHI)}, {114, 71, -1, 15, IndicNormalizer.flag(Character.UnicodeBlock.GURMUKHI)}, {115, 65, -1, 9, IndicNormalizer.flag(Character.UnicodeBlock.GURMUKHI)}, {115, 66, -1, 10, IndicNormalizer.flag(Character.UnicodeBlock.GURMUKHI)}, {115, 75, -1, 19, IndicNormalizer.flag(Character.UnicodeBlock.GURMUKHI)}};
        for (ScriptData scriptData : scripts.values()) {
            scriptData.decompMask = new BitSet(127);
            int n = 0;
            while (n < decompositions.length) {
                int n2 = decompositions[n][0];
                int n3 = decompositions[n][4];
                if ((n3 & scriptData.flag) != 0) {
                    scriptData.decompMask.set(n2);
                }
                ++n;
            }
        }
    }

    IndicNormalizer() {
    }

    private static int flag(Character.UnicodeBlock unicodeBlock) {
        return IndicNormalizer.scripts.get((Object)unicodeBlock).flag;
    }

    public int normalize(char[] cArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            int n3;
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(cArray[n2]);
            ScriptData scriptData = scripts.get(unicodeBlock);
            if (scriptData != null && scriptData.decompMask.get(n3 = cArray[n2] - scriptData.base)) {
                n = this.compose(n3, unicodeBlock, scriptData, cArray, n2, n);
            }
            ++n2;
        }
        return n;
    }

    private int compose(int n, Character.UnicodeBlock unicodeBlock, ScriptData scriptData, char[] cArray, int n2, int n3) {
        if (n2 + 1 >= n3) {
            return n3;
        }
        int n4 = cArray[n2 + 1] - scriptData.base;
        Character.UnicodeBlock unicodeBlock2 = Character.UnicodeBlock.of(cArray[n2 + 1]);
        if (unicodeBlock2 != unicodeBlock) {
            return n3;
        }
        int n5 = -1;
        if (n2 + 2 < n3) {
            n5 = cArray[n2 + 2] - scriptData.base;
            Character.UnicodeBlock unicodeBlock3 = Character.UnicodeBlock.of(cArray[n2 + 2]);
            if (cArray[n2 + 2] == '\u200d') {
                n5 = 255;
            } else if (unicodeBlock3 != unicodeBlock2) {
                n5 = -1;
            }
        }
        int n6 = 0;
        while (n6 < decompositions.length) {
            if (decompositions[n6][0] == n && (decompositions[n6][4] & scriptData.flag) != 0 && decompositions[n6][1] == n4 && (decompositions[n6][2] < 0 || decompositions[n6][2] == n5)) {
                cArray[n2] = (char)(scriptData.base + decompositions[n6][3]);
                n3 = StemmerUtil.delete(cArray, n2 + 1, n3);
                if (decompositions[n6][2] >= 0) {
                    n3 = StemmerUtil.delete(cArray, n2 + 1, n3);
                }
                return n3;
            }
            ++n6;
        }
        return n3;
    }

    private static class ScriptData {
        final int flag;
        final int base;
        BitSet decompMask;

        ScriptData(int n, int n2) {
            this.flag = n;
            this.base = n2;
        }
    }
}

