/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic.lucene;

import java.util.Arrays;
import org.carrot2.text.linguistic.IStemmer;
import org.carrot2.text.util.MutableCharArray;
import org.carrot2.util.factory.IFactory;
import org.tartarus.snowball.SnowballProgram;

public class SnowballStemmerFactory
implements IFactory<IStemmer> {
    private final Class<? extends SnowballProgram> clazz;
    private final String stemmerClazz;

    public SnowballStemmerFactory(String string) {
        this.stemmerClazz = string;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {}
        if (clazz == null) {
            try {
                clazz = Class.forName(string, true, this.getClass().getClassLoader());
            }
            catch (Throwable throwable) {}
        }
        this.clazz = clazz;
    }

    public IStemmer createInstance() {
        if (this.clazz == null) {
            throw new RuntimeException("Snowball stemmer not available: " + this.stemmerClazz);
        }
        try {
            return new SnowballStemmerAdapter(this.clazz.newInstance());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static class SnowballStemmerAdapter
    implements IStemmer {
        private final SnowballProgram snowballStemmer;

        public SnowballStemmerAdapter(SnowballProgram snowballProgram) {
            this.snowballStemmer = snowballProgram;
        }

        @Override
        public CharSequence stem(CharSequence charSequence) {
            int n = charSequence.length();
            char[] cArray = this.snowballStemmer.getCurrentBuffer();
            if (cArray.length < n) {
                cArray = new char[n];
            }
            int n2 = charSequence.length();
            while (--n2 >= 0) {
                cArray[n2] = charSequence.charAt(n2);
            }
            this.snowballStemmer.setCurrent(cArray, n);
            if (this.snowballStemmer.stem()) {
                return new MutableCharArray(Arrays.copyOf(this.snowballStemmer.getCurrentBuffer(), this.snowballStemmer.getCurrentBufferLength()));
            }
            return null;
        }
    }
}

