/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic.lucene;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.th.ThaiTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.carrot2.text.analysis.ITokenizer;
import org.carrot2.text.util.MutableCharArray;
import org.carrot2.util.ExceptionUtils;

public final class ThaiTokenizerAdapter
implements ITokenizer {
    private CharTermAttribute term = null;
    private final MutableCharArray tempCharSequence = new MutableCharArray(new char[0]);
    private ThaiTokenizer tokenizer;

    public ThaiTokenizerAdapter() {
        if (!ThaiTokenizerAdapter.platformSupportsThai()) {
            throw new RuntimeException("Thai segmentation not supported on this platform.");
        }
    }

    @Override
    public short nextToken() throws IOException {
        boolean bl = this.tokenizer.incrementToken();
        if (bl) {
            char[] cArray = this.term.buffer();
            int n = this.term.length();
            this.tempCharSequence.reset(cArray, 0, n);
            return 1;
        }
        return -1;
    }

    @Override
    public void setTermBuffer(MutableCharArray mutableCharArray) {
        mutableCharArray.reset(this.term.buffer(), 0, this.term.length());
    }

    @Override
    public void reset(Reader reader) throws IOException {
        assert (reader != null);
        try {
            this.tokenizer = new ThaiTokenizer();
            this.tokenizer.setReader(reader);
            this.term = (CharTermAttribute)this.tokenizer.addAttribute(CharTermAttribute.class);
            this.tokenizer.reset();
        }
        catch (Exception exception) {
            throw ExceptionUtils.wrapAsRuntimeException((Throwable)exception);
        }
    }

    public static boolean platformSupportsThai() {
        try {
            return ThaiTokenizer.DBBI_AVAILABLE;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

