/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.ByteArrayList;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntStack;
import com.carrotsearch.hppc.ShortArrayList;
import com.carrotsearch.hppc.sorting.IndirectSort;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import org.carrot2.core.attribute.Processing;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.SparseArray;
import org.carrot2.text.util.CharArrayComparators;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.constraint.IntRange;

@Bindable(prefix="CaseNormalizer")
public final class CaseNormalizer {
    @Processing
    @Input
    @Attribute
    @IntRange(min=1, max=100)
    @Label(value="Word document frequency threshold")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Preprocessing")
    public int dfThreshold = 1;

    public void normalize(PreprocessingContext preprocessingContext) {
        char[][] cArray = preprocessingContext.allTokens.image;
        short[] sArray = preprocessingContext.allTokens.type;
        int[] nArray = preprocessingContext.allTokens.documentIndex;
        byte[] byArray = preprocessingContext.allTokens.fieldIndex;
        int n = cArray.length;
        int[] nArray2 = IndirectSort.mergesort((Object[])cArray, (int)0, (int)cArray.length, CharArrayComparators.NORMALIZING_CHAR_ARRAY_COMPARATOR);
        ArrayList arrayList = Lists.newArrayList();
        IntArrayList intArrayList = new IntArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        ByteArrayList byteArrayList = new ByteArrayList();
        ShortArrayList shortArrayList = new ShortArrayList();
        int[] nArray3 = new int[n];
        Arrays.fill(nArray3, -1);
        int n2 = 1;
        int n3 = 1;
        int n4 = nArray2[0];
        int n5 = 1;
        int n6 = 0;
        BitSet bitSet = new BitSet((long)preprocessingContext.allFields.name.length);
        IntStack intStack = new IntStack();
        if (nArray[nArray2[0]] >= 0) {
            intStack.push(nArray[nArray2[0]]);
        }
        int n7 = 0;
        while (n7 < nArray2.length - 1) {
            char[] cArray2 = cArray[nArray2[n7]];
            char[] cArray3 = cArray[nArray2[n7 + 1]];
            short s = sArray[nArray2[n7]];
            int n8 = nArray[nArray2[n7 + 1]];
            if (cArray2 == null) break;
            if (this.isNotIndexed(s)) {
                n6 = n7 + 1;
                n4 = nArray2[n7 + 1];
                this.resetForNewTokenImage(nArray, nArray2, bitSet, intStack, n7);
            } else {
                boolean bl;
                bitSet.set((long)byArray[nArray2[n7]]);
                boolean bl2 = bl = CharArrayComparators.FAST_CHAR_ARRAY_COMPARATOR.compare(cArray2, cArray3) == 0;
                if (bl) {
                    ++n2;
                    ++n5;
                    intStack.push(n8);
                } else {
                    boolean bl3;
                    if (n3 < n2) {
                        n3 = n2;
                        n4 = nArray2[n7];
                        n2 = 1;
                    }
                    boolean bl4 = bl3 = CharArrayComparators.CASE_INSENSITIVE_CHAR_ARRAY_COMPARATOR.compare(cArray2, cArray3) == 0;
                    if (bl3) {
                        ++n5;
                        intStack.push(n8);
                    } else {
                        int[] nArray4;
                        int n9;
                        if (intStack.size() >= this.dfThreshold && (n9 = (nArray4 = SparseArray.toSparseEncoding(intStack)).length >> 1) >= this.dfThreshold) {
                            arrayList2.add(nArray4);
                            arrayList.add(cArray[n4]);
                            shortArrayList.add(sArray[n4]);
                            intArrayList.add(n5);
                            byteArrayList.add((byte)bitSet.bits[0]);
                            int n10 = n6;
                            while (n10 < n7 + 1) {
                                nArray3[nArray2[n10]] = arrayList.size() - 1;
                                ++n10;
                            }
                        }
                        n5 = 1;
                        n2 = 1;
                        n3 = 1;
                        n4 = nArray2[n7 + 1];
                        n6 = n7 + 1;
                        this.resetForNewTokenImage(nArray, nArray2, bitSet, intStack, n7);
                    }
                }
            }
            ++n7;
        }
        preprocessingContext.allTokens.wordIndex = nArray3;
        preprocessingContext.allWords.image = (char[][])arrayList.toArray((T[])new char[arrayList.size()][]);
        preprocessingContext.allWords.tf = intArrayList.toArray();
        preprocessingContext.allWords.tfByDocument = (int[][])arrayList2.toArray((T[])new int[arrayList2.size()][]);
        preprocessingContext.allWords.fieldIndices = byteArrayList.toArray();
        preprocessingContext.allWords.type = shortArrayList.toArray();
    }

    private void resetForNewTokenImage(int[] nArray, int[] nArray2, BitSet bitSet, IntStack intStack, int n) {
        bitSet.clear();
        intStack.clear();
        if (nArray[nArray2[n + 1]] >= 0) {
            intStack.push(nArray[nArray2[n + 1]]);
        }
    }

    private boolean isNotIndexed(int n) {
        return n == 3 || n == 6 || (n & 0x100) != 0;
    }
}

