/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntArrayList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.carrot2.core.attribute.Processing;
import org.carrot2.text.analysis.TokenTypeUtils;
import org.carrot2.text.preprocessing.LabelFilterProcessor;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.constraint.IntRange;

@Bindable(prefix="DocumentAssigner")
public class DocumentAssigner {
    @Input
    @Processing
    @Attribute
    @Label(value="Exact phrase assignment")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Preprocessing")
    public boolean exactPhraseAssignment = false;
    @Input
    @Processing
    @Attribute
    @IntRange(min=1, max=100)
    @Label(value="Minimum cluster size")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Preprocessing")
    public int minClusterSize = 2;

    public void assign(PreprocessingContext preprocessingContext) {
        int n;
        Object object;
        int[] nArray = preprocessingContext.allLabels.featureIndex;
        int[][] nArray2 = preprocessingContext.allStems.tfByDocument;
        int[] nArray3 = preprocessingContext.allWords.stemIndex;
        short[] sArray = preprocessingContext.allWords.type;
        int[][] nArray4 = preprocessingContext.allPhrases.tfByDocument;
        int[][] nArray5 = preprocessingContext.allPhrases.wordIndices;
        int n2 = nArray3.length;
        int n3 = preprocessingContext.documents.size();
        BitSet[] bitSetArray = new BitSet[nArray.length];
        int n4 = 0;
        while (n4 < nArray.length) {
            object = new BitSet((long)n3);
            n = nArray[n4];
            if (n < n2) {
                DocumentAssigner.addTfByDocumentToBitSet((BitSet)object, nArray2[nArray3[n]]);
            } else {
                int n5 = n - n2;
                if (this.exactPhraseAssignment) {
                    DocumentAssigner.addTfByDocumentToBitSet((BitSet)object, nArray4[n5]);
                } else {
                    int[] nArray6 = nArray5[n5];
                    boolean bl = false;
                    int n6 = 0;
                    while (n6 < nArray6.length) {
                        int n7 = nArray6[n6];
                        if (!TokenTypeUtils.isCommon(sArray[n7])) {
                            if (!bl) {
                                DocumentAssigner.addTfByDocumentToBitSet((BitSet)object, nArray2[nArray3[n7]]);
                                bl = true;
                            } else {
                                BitSet bitSet = new BitSet((long)n3);
                                DocumentAssigner.addTfByDocumentToBitSet(bitSet, nArray2[nArray3[n7]]);
                                object.and(bitSet);
                            }
                        }
                        ++n6;
                    }
                }
            }
            bitSetArray[n4] = object;
            ++n4;
        }
        if (this.minClusterSize > 1) {
            IntArrayList intArrayList = new IntArrayList(nArray.length);
            object = Lists.newArrayListWithExpectedSize((int)nArray.length);
            n = 0;
            while (n < nArray.length) {
                if (bitSetArray[n].cardinality() >= (long)this.minClusterSize) {
                    intArrayList.add(nArray[n]);
                    ((ArrayList)object).add(bitSetArray[n]);
                }
                ++n;
            }
            preprocessingContext.allLabels.documentIndices = ((ArrayList)object).toArray(new BitSet[((ArrayList)object).size()]);
            preprocessingContext.allLabels.featureIndex = intArrayList.toArray();
            LabelFilterProcessor.updateFirstPhraseIndex(preprocessingContext);
        } else {
            preprocessingContext.allLabels.documentIndices = bitSetArray;
        }
    }

    private static void addTfByDocumentToBitSet(BitSet bitSet, int[] nArray) {
        int n = 0;
        while (n < nArray.length / 2) {
            bitSet.set((long)nArray[n * 2]);
            ++n;
        }
    }
}

