/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import com.carrotsearch.hppc.IntArrayList;
import java.util.Arrays;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.CompleteLabelFilter;
import org.carrot2.text.preprocessing.filter.GenitiveLabelFilter;
import org.carrot2.text.preprocessing.filter.MinLengthLabelFilter;
import org.carrot2.text.preprocessing.filter.NumericLabelFilter;
import org.carrot2.text.preprocessing.filter.QueryLabelFilter;
import org.carrot2.text.preprocessing.filter.StopLabelFilter;
import org.carrot2.text.preprocessing.filter.StopWordLabelFilter;
import org.carrot2.util.attribute.Bindable;

@Bindable(prefix="LabelFilterProcessor")
public class LabelFilterProcessor {
    public QueryLabelFilter queryLabelFilter = new QueryLabelFilter();
    public StopWordLabelFilter stopWordLabelFilter = new StopWordLabelFilter();
    public NumericLabelFilter numericLabelFilter = new NumericLabelFilter();
    public CompleteLabelFilter completeLabelFilter = new CompleteLabelFilter();
    public MinLengthLabelFilter minLengthLabelFilter = new MinLengthLabelFilter();
    public GenitiveLabelFilter genitiveLabelFilter = new GenitiveLabelFilter();
    public StopLabelFilter stopLabelFilter = new StopLabelFilter();

    public void process(PreprocessingContext preprocessingContext) {
        int n = preprocessingContext.allWords.image.length;
        boolean[] blArray = new boolean[preprocessingContext.allStems.image.length];
        boolean[] blArray2 = new boolean[preprocessingContext.allPhrases.tf.length];
        Arrays.fill(blArray, true);
        Arrays.fill(blArray2, true);
        this.minLengthLabelFilter.filter(preprocessingContext, blArray, blArray2);
        this.genitiveLabelFilter.filter(preprocessingContext, blArray, blArray2);
        this.queryLabelFilter.filter(preprocessingContext, blArray, blArray2);
        this.stopWordLabelFilter.filter(preprocessingContext, blArray, blArray2);
        this.numericLabelFilter.filter(preprocessingContext, blArray, blArray2);
        this.stopLabelFilter.filter(preprocessingContext, blArray, blArray2);
        this.completeLabelFilter.filter(preprocessingContext, blArray, blArray2);
        IntArrayList intArrayList = new IntArrayList(blArray.length + blArray2.length);
        int[] nArray = preprocessingContext.allStems.mostFrequentOriginalWordIndex;
        int n2 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2]) {
                intArrayList.add(nArray[n2]);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < blArray2.length) {
            if (blArray2[n2]) {
                intArrayList.add(n2 + n);
            }
            ++n2;
        }
        preprocessingContext.allLabels.featureIndex = intArrayList.toArray();
        LabelFilterProcessor.updateFirstPhraseIndex(preprocessingContext);
    }

    static void updateFirstPhraseIndex(PreprocessingContext preprocessingContext) {
        int n = preprocessingContext.allWords.image.length;
        int[] nArray = preprocessingContext.allLabels.featureIndex;
        int n2 = -1;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] >= n) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        preprocessingContext.allLabels.firstPhraseIndex = n2;
    }
}

