/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import org.carrot2.text.analysis.TokenTypeUtils;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.util.CharArrayUtils;
import org.carrot2.util.attribute.Bindable;

@Bindable
public class LabelFormatter {
    public String format(PreprocessingContext preprocessingContext, int n) {
        char[][] cArray = preprocessingContext.allWords.image;
        int[][] nArray = preprocessingContext.allPhrases.wordIndices;
        int n2 = cArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        if (n < n2) {
            char[] cArray2 = cArray[n];
            LabelFormatter.appendFormatted(stringBuilder, cArray2, true, false);
        } else {
            boolean bl = preprocessingContext.language.getLanguageCode().usesSpaceDelimiters();
            int[] nArray2 = nArray[n - n2];
            short[] sArray = preprocessingContext.allWords.type;
            int n3 = 0;
            while (n3 < nArray2.length) {
                if (bl && n3 > 0) {
                    stringBuilder.append(' ');
                }
                int n4 = nArray2[n3];
                LabelFormatter.appendFormatted(stringBuilder, cArray[n4], n3 == 0, TokenTypeUtils.isCommon(sArray[n4]));
                ++n3;
            }
        }
        return stringBuilder.toString();
    }

    public static String format(char[][] cArray, boolean[] blArray, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (cArray.length == 1) {
            LabelFormatter.appendFormatted(stringBuilder, cArray[0], true, blArray[0]);
        } else {
            int n = 0;
            while (n < cArray.length) {
                LabelFormatter.appendFormatted(stringBuilder, cArray[n], n == 0, blArray[n]);
                if (bl && n < cArray.length - 1) {
                    stringBuilder.append(' ');
                }
                ++n;
            }
        }
        return stringBuilder.toString();
    }

    private static void appendFormatted(StringBuilder stringBuilder, char[] cArray, boolean bl, boolean bl2) {
        if (CharArrayUtils.hasCapitalizedLetters((char[])cArray)) {
            stringBuilder.append(cArray);
        } else if (bl) {
            stringBuilder.append(CharArrayUtils.toCapitalizedCopy((char[])cArray));
        } else if (bl2) {
            stringBuilder.append(CharArrayUtils.toLowerCaseCopy((char[])cArray));
        } else {
            stringBuilder.append(CharArrayUtils.toCapitalizedCopy((char[])cArray));
        }
    }
}

