/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import com.carrotsearch.hppc.ByteArrayList;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.sorting.IndirectSort;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.carrot2.text.linguistic.IStemmer;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.SparseArray;
import org.carrot2.text.util.CharArrayComparators;
import org.carrot2.text.util.MutableCharArray;
import org.carrot2.util.CharArrayUtils;
import org.carrot2.util.attribute.Bindable;

@Bindable(prefix="LanguageModelStemmer")
public final class LanguageModelStemmer {
    public void stem(PreprocessingContext preprocessingContext) {
        IStemmer iStemmer = preprocessingContext.language.getStemmer();
        char[][] cArray = preprocessingContext.allWords.image;
        char[][] cArrayArray = new char[cArray.length][];
        MutableCharArray mutableCharArray = new MutableCharArray(CharArrayUtils.EMPTY_ARRAY);
        char[] cArray2 = new char[128];
        int n = 0;
        while (n < cArray.length) {
            char[] cArray3 = cArray[n];
            if (cArray2.length < cArray3.length) {
                cArray2 = new char[cArray3.length];
            }
            boolean bl = CharArrayUtils.toLowerCase((char[])cArray3, (char[])cArray2);
            mutableCharArray.reset(cArray2, 0, cArray3.length);
            CharSequence charSequence = iStemmer.stem(mutableCharArray);
            if (charSequence != null) {
                mutableCharArray.reset(charSequence);
                cArrayArray[n] = preprocessingContext.intern(mutableCharArray);
            } else {
                cArrayArray[n] = bl ? preprocessingContext.intern(mutableCharArray) : cArray3;
            }
            ++n;
        }
        this.addStemStatistics(preprocessingContext, cArrayArray, this.prepareQueryWords(preprocessingContext.query, iStemmer));
    }

    private void addStemStatistics(PreprocessingContext preprocessingContext, char[][] cArray, Set<MutableCharArray> set) {
        int[] nArray = IndirectSort.mergesort((Object[])cArray, (int)0, (int)cArray.length, CharArrayComparators.FAST_CHAR_ARRAY_COMPARATOR);
        int[] nArray2 = preprocessingContext.allWords.tf;
        int[][] nArray3 = preprocessingContext.allWords.tfByDocument;
        byte[] byArray = preprocessingContext.allWords.fieldIndices;
        short[] sArray = preprocessingContext.allWords.type;
        int n = nArray2.length;
        int[] nArray4 = new int[n];
        if (nArray.length == 0) {
            preprocessingContext.allStems.image = new char[0][];
            preprocessingContext.allStems.mostFrequentOriginalWordIndex = new int[0];
            preprocessingContext.allStems.tf = new int[0];
            preprocessingContext.allStems.tfByDocument = new int[0][];
            preprocessingContext.allStems.fieldIndices = new byte[0];
            preprocessingContext.allWords.stemIndex = new int[preprocessingContext.allWords.image.length];
            return;
        }
        ArrayList<char[]> arrayList = new ArrayList<char[]>(n);
        IntArrayList intArrayList = new IntArrayList(n);
        IntArrayList intArrayList2 = new IntArrayList(n);
        ArrayList<int[]> arrayList2 = new ArrayList<int[]>(n);
        ByteArrayList byteArrayList = new ByteArrayList();
        int n2 = nArray2[nArray[0]];
        int n3 = nArray2[nArray[0]];
        int n4 = nArray[0];
        int n5 = 0;
        ArrayList arrayList3 = Lists.newArrayList();
        arrayList3.add(nArray3[nArray[0]]);
        byte by = 0;
        by = (byte)(by | byArray[0]);
        MutableCharArray mutableCharArray = new MutableCharArray(cArray[nArray[0]]);
        boolean bl = set.contains(mutableCharArray);
        int n6 = 0;
        while (n6 < nArray.length - 1) {
            boolean bl2;
            int n7 = nArray[n6];
            char[] cArray2 = cArray[n7];
            int n8 = nArray[n6 + 1];
            char[] cArray3 = cArray[n8];
            nArray4[n7] = n5;
            if (bl) {
                int n9 = n7;
                sArray[n9] = (short)(sArray[n9] | 0x2000);
            }
            boolean bl3 = bl2 = CharArrayComparators.FAST_CHAR_ARRAY_COMPARATOR.compare(cArray2, cArray3) == 0;
            if (bl2) {
                n2 += nArray2[n8];
                arrayList3.add(nArray3[n8]);
                by = (byte)(by | byArray[n8]);
                if (n3 < nArray2[n8]) {
                    n3 = nArray2[n8];
                    n4 = n8;
                }
            } else {
                arrayList.add(cArray2);
                intArrayList.add(n2);
                intArrayList2.add(n4);
                this.storeTfByDocument(arrayList2, arrayList3);
                byteArrayList.add(by);
                ++n5;
                n2 = nArray2[n8];
                n3 = nArray2[n8];
                n4 = n8;
                by = 0;
                by = (byte)(by | byArray[n8]);
                arrayList3.clear();
                arrayList3.add(nArray3[n8]);
                mutableCharArray.reset(cArray[n8]);
                bl = set.contains(mutableCharArray);
            }
            ++n6;
        }
        arrayList.add(cArray[nArray[nArray.length - 1]]);
        intArrayList.add(n2);
        intArrayList2.add(n4);
        nArray4[nArray[nArray.length - 1]] = n5;
        this.storeTfByDocument(arrayList2, arrayList3);
        byteArrayList.add(by);
        if (bl) {
            int n10 = nArray[nArray.length - 1];
            sArray[n10] = (short)(sArray[n10] | 0x2000);
        }
        preprocessingContext.allStems.image = (char[][])arrayList.toArray((T[])new char[arrayList.size()][]);
        preprocessingContext.allStems.mostFrequentOriginalWordIndex = intArrayList2.toArray();
        preprocessingContext.allStems.tf = intArrayList.toArray();
        preprocessingContext.allStems.tfByDocument = (int[][])arrayList2.toArray((T[])new int[arrayList2.size()][]);
        preprocessingContext.allStems.fieldIndices = byteArrayList.toArray();
        preprocessingContext.allWords.stemIndex = nArray4;
    }

    private void storeTfByDocument(ArrayList<int[]> arrayList, ArrayList<int[]> arrayList2) {
        assert (arrayList2.size() > 0) : "Empty source document list?";
        if (arrayList2.size() == 1) {
            arrayList.add(arrayList2.get(0));
        } else {
            arrayList.add(SparseArray.mergeSparseArrays(arrayList2));
        }
    }

    private Set<MutableCharArray> prepareQueryWords(String string, IStemmer iStemmer) {
        HashSet hashSet = Sets.newHashSet();
        if (string != null) {
            String[] stringArray = string.toLowerCase().split("\\s");
            int n = 0;
            while (n < stringArray.length) {
                CharSequence charSequence = iStemmer.stem(stringArray[n]);
                if (charSequence != null) {
                    hashSet.add(new MutableCharArray(charSequence));
                } else {
                    hashSet.add(new MutableCharArray(stringArray[n]));
                }
                ++n;
            }
        }
        return hashSet;
    }
}

