/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class PhraseExtractorDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.text.preprocessing.PhraseExtractor";
    public final String prefix = "PhraseExtractor";
    public final String title = "Extracts frequent phrases from the provided document";
    public final String label = "";
    public final String description = "A frequent phrase is a sequence of words that appears in the documents more than once. This phrase extractor aggregates different inflection variants of phrase words into one phrase, returning the most frequent variant. For example, if phrase <i>computing science</i> appears 2 times and <i>computer sciences</i> appears 4 times, the latter will be returned with aggregated frequency of 6. <p> This class saves the following results to the <code>PreprocessingContext</code>: <ul> <li><code>AllPhrases.wordIndices</code></li> <li><code>AllPhrases.tf</code></li> <li><code>AllPhrases.tfByDocument</code></li> <li><code>AllTokens.suffixOrder</code></li> <li><code>AllTokens.lcp</code></li> </ul> <p> This class requires that <code>Tokenizer</code>, <code>CaseNormalizer</code> and <code>LanguageModelStemmer</code> be invoked first.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(PhraseExtractorDescriptor.attributes.dfThreshold);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(PhraseExtractorDescriptor.attributes.dfThreshold);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "PhraseExtractor";
    }

    public String getTitle() {
        return "Extracts frequent phrases from the provided document";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "A frequent phrase is a sequence of words that appears in the documents more than once. This phrase extractor aggregates different inflection variants of phrase words into one phrase, returning the most frequent variant. For example, if phrase <i>computing science</i> appears 2 times and <i>computer sciences</i> appears 4 times, the latter will be returned with aggregated frequency of 6. <p> This class saves the following results to the <code>PreprocessingContext</code>: <ul> <li><code>AllPhrases.wordIndices</code></li> <li><code>AllPhrases.tf</code></li> <li><code>AllPhrases.tfByDocument</code></li> <li><code>AllTokens.suffixOrder</code></li> <li><code>AllTokens.lcp</code></li> </ul> <p> This class requires that <code>Tokenizer</code>, <code>CaseNormalizer</code> and <code>LanguageModelStemmer</code> be invoked first.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder dfThreshold(int n) {
            this.map.put("PhraseExtractor.dfThreshold", n);
            return this;
        }

        public AttributeBuilder dfThreshold(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("PhraseExtractor.dfThreshold", iObjectFactory);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo dfThreshold = new AttributeInfo("PhraseExtractor.dfThreshold", "org.carrot2.text.preprocessing.PhraseExtractor", "dfThreshold", "Phrase Document Frequency threshold. Phrases appearing in fewer than\n<code>dfThreshold</code> documents will be ignored.", "Phrase document frequency threshold", "Phrase Document Frequency threshold", "Phrases appearing in fewer than <code>dfThreshold</code> documents will be ignored.", "Phrase extraction", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys {
        public static final String DF_THRESHOLD = "PhraseExtractor.dfThreshold";

        protected Keys() {
        }
    }
}

