/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.ObjectHashSet;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import org.carrot2.core.Document;
import org.carrot2.text.linguistic.LanguageModel;
import org.carrot2.text.preprocessing.SparseArray;
import org.carrot2.text.util.MutableCharArray;
import org.carrot2.text.util.TabularOutput;

public final class PreprocessingContext {
    private static final String UNINITIALIZED = "[uninitialized]\n";
    public final String query;
    public final List<Document> documents;
    public final LanguageModel language;
    private ObjectHashSet<MutableCharArray> tokenCache = new ObjectHashSet();
    public final AllTokens allTokens = new AllTokens();
    public final AllFields allFields = new AllFields();
    public final AllWords allWords = new AllWords();
    public final AllStems allStems = new AllStems();
    public AllPhrases allPhrases = new AllPhrases();
    public final AllLabels allLabels = new AllLabels();
    private static final int[][] bitsCache = new int[256][];

    static {
        int n = 0;
        while (n < 256) {
            PreprocessingContext.bitsCache[n] = new int[Integer.bitCount(n & 0xFF)];
            int n2 = 0;
            int n3 = 0;
            int n4 = n & 0xFF;
            while (n4 != 0) {
                if ((n4 & 1) != 0) {
                    PreprocessingContext.bitsCache[n][n2++] = n3;
                }
                n4 >>>= 1;
                ++n3;
            }
            ++n;
        }
    }

    public PreprocessingContext(LanguageModel languageModel, List<Document> list, String string) {
        this.query = string;
        this.documents = list;
        this.language = languageModel;
    }

    public boolean hasWords() {
        return this.allWords.image.length > 0;
    }

    public boolean hasLabels() {
        return this.allLabels.featureIndex != null && this.allLabels.featureIndex.length > 0;
    }

    public String toString() {
        return "PreprocessingContext 0x" + Integer.toHexString(this.hashCode()) + "\n" + "== Fields:\n" + this.allFields.toString() + "== Tokens:\n" + this.allTokens.toString() + "== Words:\n" + this.allWords.toString() + "== Stems:\n" + this.allStems.toString() + "== Phrases:\n" + this.allPhrases.toString() + "== Labels:\n" + this.allLabels.toString();
    }

    public static int[] toFieldIndexes(byte by) {
        return bitsCache[by & 0xFF];
    }

    public void preprocessingFinished() {
        this.tokenCache = null;
    }

    public char[] intern(MutableCharArray mutableCharArray) {
        int n = this.tokenCache.indexOf((Object)mutableCharArray);
        if (this.tokenCache.indexExists(n)) {
            return ((MutableCharArray)this.tokenCache.indexGet(n)).getBuffer();
        }
        char[] cArray = new char[mutableCharArray.length()];
        System.arraycopy(mutableCharArray.getBuffer(), mutableCharArray.getStart(), cArray, 0, mutableCharArray.length());
        this.tokenCache.add((Object)new MutableCharArray(cArray));
        return cArray;
    }

    public static class AllFields {
        public String[] name;

        public String toString() {
            if (this.name == null) {
                return PreprocessingContext.UNINITIALIZED;
            }
            StringWriter stringWriter = new StringWriter();
            TabularOutput tabularOutput = new TabularOutput(stringWriter);
            tabularOutput.flushEvery(Integer.MAX_VALUE);
            tabularOutput.addColumn("#");
            tabularOutput.addColumn("name").format("%-10s").alignLeft();
            int n = 0;
            String[] stringArray = this.name;
            int n2 = this.name.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray[n3];
                tabularOutput.rowData(n++, string).nextRow();
                ++n3;
            }
            tabularOutput.flush();
            stringWriter.append("\n");
            return stringWriter.toString();
        }
    }

    public class AllLabels {
        public int[] featureIndex;
        public BitSet[] documentIndices;
        public int firstPhraseIndex;

        public String toString() {
            if (this.featureIndex == null) {
                return PreprocessingContext.UNINITIALIZED;
            }
            StringWriter stringWriter = new StringWriter();
            TabularOutput tabularOutput = new TabularOutput(stringWriter);
            tabularOutput.flushEvery(Integer.MAX_VALUE);
            tabularOutput.addColumn("#");
            tabularOutput.addColumn("featureIdx");
            tabularOutput.addColumn("=>feature").alignLeft();
            tabularOutput.addColumn("documentIdx").alignLeft();
            int n = 0;
            while (n < this.featureIndex.length) {
                tabularOutput.rowData(n, this.featureIndex[n], this.getLabel(n), this.documentIndices != null ? this.documentIndices[n].toString().replace(" ", "") : "");
                ++n;
                tabularOutput.nextRow();
            }
            tabularOutput.flush();
            stringWriter.append("\n");
            return tabularOutput.toString();
        }

        private CharSequence getLabel(int n) {
            int n2 = PreprocessingContext.this.allWords.image.length;
            if (this.featureIndex[n] < n2) {
                return new String(PreprocessingContext.this.allWords.image[this.featureIndex[n]]);
            }
            return PreprocessingContext.this.allPhrases.getPhrase(this.featureIndex[n] - n2);
        }
    }

    public class AllPhrases {
        public int[][] wordIndices;
        public int[] tf;
        public int[][] tfByDocument;

        public String toString() {
            if (this.wordIndices == null) {
                return PreprocessingContext.UNINITIALIZED;
            }
            StringWriter stringWriter = new StringWriter();
            TabularOutput tabularOutput = new TabularOutput(stringWriter);
            tabularOutput.flushEvery(Integer.MAX_VALUE);
            tabularOutput.addColumn("#");
            tabularOutput.addColumn("wordIndices");
            tabularOutput.addColumn("=>words").alignLeft();
            tabularOutput.addColumn("tf");
            tabularOutput.addColumn("tfByDocument").alignLeft();
            int n = 0;
            while (n < this.wordIndices.length) {
                tabularOutput.rowData(n, Arrays.toString(this.wordIndices[n]).replace(" ", ""), this.getPhrase(n), this.tf[n], SparseArray.sparseToString(this.tfByDocument[n]));
                ++n;
                tabularOutput.nextRow();
            }
            tabularOutput.flush();
            stringWriter.append("\n");
            return stringWriter.toString();
        }

        public CharSequence getPhrase(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            while (n2 < this.wordIndices[n].length) {
                if (n2 > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(new String(PreprocessingContext.this.allWords.image[this.wordIndices[n][n2]]));
                ++n2;
            }
            return stringBuilder;
        }

        public int size() {
            return this.wordIndices.length;
        }
    }

    public class AllStems {
        public char[][] image;
        public int[] mostFrequentOriginalWordIndex;
        public int[] tf;
        public int[][] tfByDocument;
        public byte[] fieldIndices;

        public String toString() {
            if (this.image == null) {
                return PreprocessingContext.UNINITIALIZED;
            }
            StringWriter stringWriter = new StringWriter();
            TabularOutput tabularOutput = new TabularOutput(stringWriter);
            tabularOutput.flushEvery(Integer.MAX_VALUE);
            tabularOutput.addColumn("#");
            tabularOutput.addColumn("stem");
            tabularOutput.addColumn("mostFrqWord");
            tabularOutput.addColumn("=>mostFrqWord").alignLeft();
            tabularOutput.addColumn("tf");
            tabularOutput.addColumn("tfByDocument").alignLeft();
            tabularOutput.addColumn("fieldIndices");
            int n = 0;
            while (n < this.image.length) {
                tabularOutput.rowData(n, this.image[n] == null ? "<null>" : new String(this.image[n]), this.mostFrequentOriginalWordIndex[n], new String(PreprocessingContext.this.allWords.image[this.mostFrequentOriginalWordIndex[n]]), this.tf[n], SparseArray.sparseToString(this.tfByDocument[n]), Arrays.toString(PreprocessingContext.toFieldIndexes(this.fieldIndices[n])).replace(" ", ""));
                ++n;
                tabularOutput.nextRow();
            }
            tabularOutput.flush();
            stringWriter.append("\n");
            return stringWriter.toString();
        }
    }

    public class AllTokens {
        public char[][] image;
        public short[] type;
        public byte[] fieldIndex;
        public int[] documentIndex;
        public int[] wordIndex;
        public int[] suffixOrder;
        public int[] lcp;

        public String toString() {
            if (this.image == null) {
                return PreprocessingContext.UNINITIALIZED;
            }
            StringWriter stringWriter = new StringWriter();
            TabularOutput tabularOutput = new TabularOutput(stringWriter);
            tabularOutput.flushEvery(Integer.MAX_VALUE);
            tabularOutput.addColumn("#");
            tabularOutput.addColumn("token").alignLeft();
            tabularOutput.addColumn("type");
            tabularOutput.addColumn("fieldIndex");
            tabularOutput.addColumn("=>field").alignLeft();
            tabularOutput.addColumn("docIdx");
            tabularOutput.addColumn("wordIdx");
            tabularOutput.addColumn("=>word").alignLeft();
            int n = 0;
            while (n < this.image.length) {
                tabularOutput.rowData(n, this.image[n] == null ? "<null>" : new String(this.image[n]), this.type[n], this.fieldIndex[n], this.fieldIndex[n] >= 0 ? PreprocessingContext.this.allFields.name[this.fieldIndex[n]] : null, this.documentIndex[n], this.wordIndex[n], this.wordIndex[n] >= 0 ? new String(PreprocessingContext.this.allWords.image[this.wordIndex[n]]) : null);
                ++n;
                tabularOutput.nextRow();
            }
            if (this.suffixOrder != null) {
                tabularOutput = new TabularOutput(stringWriter);
                tabularOutput.addColumn("#");
                tabularOutput.addColumn("sa");
                tabularOutput.addColumn("lcp");
                tabularOutput.addColumn("=>words").alignLeft();
                stringWriter.append("\n");
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = 0;
                while (n2 < this.suffixOrder.length) {
                    tabularOutput.rowData(n2, this.suffixOrder[n2], this.lcp[n2]);
                    int n3 = 5;
                    int n4 = this.suffixOrder[n2];
                    int n5 = Math.min(this.suffixOrder[n2] + n3, this.wordIndex.length);
                    while (n4 < n5) {
                        stringBuilder.append(this.wordIndex[n4] >= 0 ? new String(PreprocessingContext.this.allWords.image[this.wordIndex[n4]]) : "|").append(" ");
                        if (++n4 != n5 || n4 == this.wordIndex.length) continue;
                        stringBuilder.append(" [...]");
                    }
                    tabularOutput.rowData(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    ++n2;
                    tabularOutput.nextRow();
                }
                stringWriter.append("\n");
            }
            tabularOutput.flush();
            stringWriter.append("\n");
            return stringWriter.toString();
        }
    }

    public class AllWords {
        public char[][] image;
        public short[] type;
        public int[] tf;
        public int[][] tfByDocument;
        public int[] stemIndex;
        public byte[] fieldIndices;

        public String toString() {
            if (this.image == null) {
                return PreprocessingContext.UNINITIALIZED;
            }
            StringWriter stringWriter = new StringWriter();
            TabularOutput tabularOutput = new TabularOutput(stringWriter);
            tabularOutput.flushEvery(Integer.MAX_VALUE);
            tabularOutput.addColumn("#");
            tabularOutput.addColumn("image").alignLeft();
            tabularOutput.addColumn("type");
            tabularOutput.addColumn("tf");
            tabularOutput.addColumn("tfByDocument").alignLeft();
            tabularOutput.addColumn("fieldIndices");
            if (this.stemIndex != null) {
                tabularOutput.addColumn("stemIndex");
                tabularOutput.addColumn("=>stem").alignLeft();
            }
            int n = 0;
            while (n < this.image.length) {
                tabularOutput.rowData(n, this.image[n] == null ? "<null>" : new String(this.image[n]), this.type[n], this.tf[n], SparseArray.sparseToString(this.tfByDocument[n]));
                tabularOutput.rowData(Arrays.toString(PreprocessingContext.toFieldIndexes(this.fieldIndices[n])).replace(" ", ""));
                if (this.stemIndex != null) {
                    tabularOutput.rowData(this.stemIndex[n]);
                    tabularOutput.rowData(new String(PreprocessingContext.this.allStems.image[this.stemIndex[n]]));
                }
                ++n;
                tabularOutput.nextRow();
            }
            tabularOutput.flush();
            stringWriter.append("\n");
            return stringWriter.toString();
        }
    }
}

