/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.IntStack;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import java.util.Arrays;

public final class SparseArray {
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    public static int[] toSparseEncoding(IntStack intStack) {
        if (intStack.size() == 0) {
            return EMPTY_INT_ARRAY;
        }
        if (intStack.size() < 1000) {
            return SparseArray.toSparseEncodingBySort(intStack);
        }
        return SparseArray.toSparseEncodingByHash(intStack);
    }

    public static int[] toSparseEncodingByHash(IntStack intStack) {
        IntIntHashMap intIntHashMap = new IntIntHashMap();
        int n = intStack.size();
        int[] nArray = intStack.buffer;
        int n2 = 0;
        while (n2 < n) {
            intIntHashMap.putOrAdd(nArray[n2], 1, 1);
            ++n2;
        }
        return SparseArray.hashToKeyValuePairs(intIntHashMap);
    }

    private static int[] hashToKeyValuePairs(IntIntHashMap intIntHashMap) {
        int[] nArray = new int[intIntHashMap.size() * 2];
        int n = 0;
        for (IntIntCursor intIntCursor : intIntHashMap) {
            nArray[n++] = intIntCursor.key;
            nArray[n++] = intIntCursor.value;
        }
        return nArray;
    }

    public static int[] toSparseEncodingBySort(IntStack intStack) {
        Arrays.sort(intStack.buffer, 0, intStack.size());
        int[] nArray = new int[2 * SparseArray.countUnique(intStack.buffer, 0, intStack.size())];
        int n = intStack.size();
        int[] nArray2 = intStack.buffer;
        int n2 = nArray2[0];
        int n3 = 1;
        int n4 = 0;
        int n5 = 1;
        while (n5 < n) {
            int n6 = nArray2[n5];
            if (n6 != n2) {
                nArray[n4++] = n2;
                nArray[n4++] = n3;
                n3 = 0;
                n2 = n6;
            }
            ++n3;
            ++n5;
        }
        if (n4 < nArray.length) {
            nArray[n4++] = n2;
            nArray[n4++] = n3;
        }
        assert (n4 == nArray.length);
        return nArray;
    }

    public static int countUnique(int[] nArray, int n, int n2) {
        int n3 = 0;
        if (n < n2) {
            int n4 = nArray[n];
            ++n3;
            int n5 = n + 1;
            while (n5 < n2) {
                int n6 = nArray[n5];
                assert (n6 >= n4) : "Not sorted as expected.";
                if (n4 != n6) {
                    ++n3;
                    n4 = n6;
                }
                ++n5;
            }
        }
        return n3;
    }

    public static int[] mergeSparseArrays(Iterable<int[]> iterable) {
        IntIntHashMap intIntHashMap = new IntIntHashMap();
        for (int[] nArray : iterable) {
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2 + 1];
                intIntHashMap.putOrAdd(nArray[n2], n3, n3);
                n2 += 2;
            }
        }
        return SparseArray.hashToKeyValuePairs(intIntHashMap);
    }

    public static String sparseToString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 10;
        int n2 = 0;
        int n3 = Math.min(n, nArray.length);
        while (n2 < n3) {
            stringBuilder.append(nArray[n2]).append("=>").append(nArray[n2 + 1]);
            stringBuilder.append(",");
            n2 += 2;
        }
        if (nArray.length > n) {
            stringBuilder.append("...");
        }
        return stringBuilder.toString();
    }
}

