/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.core.attribute.Processing;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.ILabelFilter;
import org.carrot2.text.preprocessing.filter.LeftCompleteLabelFilter;
import org.carrot2.text.preprocessing.filter.RightCompleteLabelFilter;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.constraint.DoubleRange;

@Bindable(prefix="CompleteLabelFilter")
public class CompleteLabelFilter
implements ILabelFilter {
    @Input
    @Processing
    @Attribute
    @Label(value="Remove truncated phrases")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Labels")
    public boolean enabled = true;
    @Input
    @Processing
    @Attribute
    @DoubleRange(min=0.0, max=1.0)
    @Label(value="Truncated label threshold")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Labels")
    public double labelOverrideThreshold = 0.65;
    private LeftCompleteLabelFilter leftCompleteLabelFilter = new LeftCompleteLabelFilter();
    private RightCompleteLabelFilter rightCompleteLabelFilter = new RightCompleteLabelFilter();

    @Override
    public void filter(PreprocessingContext preprocessingContext, boolean[] blArray, boolean[] blArray2) {
        if (!this.enabled) {
            return;
        }
        this.leftCompleteLabelFilter.filter(preprocessingContext, blArray, blArray2, this.labelOverrideThreshold);
        this.rightCompleteLabelFilter.filter(preprocessingContext, blArray, blArray2, this.labelOverrideThreshold);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

