/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.carrot2.text.preprocessing.PreprocessingContext;

abstract class CompleteLabelFilterBase {
    CompleteLabelFilterBase() {
    }

    void filter(PreprocessingContext preprocessingContext, boolean[] blArray, boolean[] blArray2, double d) {
        if (blArray.length + blArray2.length < 2) {
            return;
        }
        int[] nArray = preprocessingContext.allStems.tf;
        int[] nArray2 = preprocessingContext.allPhrases.tf;
        int[] nArray3 = preprocessingContext.allStems.mostFrequentOriginalWordIndex;
        int[] nArray4 = preprocessingContext.allWords.stemIndex;
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)(blArray.length + blArray2.length));
        int n = 0;
        while (n < blArray.length + blArray2.length) {
            arrayList.add(new LabelIndexWithCodes(n, CompleteLabelFilterBase.getLabelWordIndexes(blArray.length, nArray3, preprocessingContext.allPhrases.wordIndices, n)));
            ++n;
        }
        List<LabelIndexWithCodes> list = this.sortPhraseCodes(arrayList);
        int[] nArray5 = this.createLcp(list);
        int n2 = 0;
        while (n2 < list.size() - 1) {
            LabelIndexWithCodes labelIndexWithCodes = list.get(n2);
            int n3 = labelIndexWithCodes.getLabelIndex();
            if (CompleteLabelFilterBase.getLabelLength(blArray.length, preprocessingContext.allPhrases.wordIndices, n3) == nArray5[n2] && CompleteLabelFilterBase.isLabelAccepted(blArray.length, nArray4, n3, blArray, blArray2)) {
                int n4 = n2;
                while (n4 < list.size() - 1 && nArray5[n4] >= nArray5[n2]) {
                    LabelIndexWithCodes labelIndexWithCodes2 = list.get(n4 + 1);
                    int n5 = labelIndexWithCodes2.getLabelIndex();
                    double d2 = CompleteLabelFilterBase.calculateLabelOverride(blArray.length, nArray, nArray2, n5, n3);
                    if (CompleteLabelFilterBase.isLabelAccepted(blArray.length, nArray4, n5, blArray, blArray2) && d2 >= d) {
                        CompleteLabelFilterBase.markLabelAsRemoved(blArray.length, n3, blArray, blArray2);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    abstract List<LabelIndexWithCodes> sortPhraseCodes(List<LabelIndexWithCodes> var1);

    abstract int[] createLcp(List<LabelIndexWithCodes> var1);

    private static final int[] getLabelWordIndexes(int n, int[] nArray, int[][] nArray2, int n2) {
        if (n2 < n) {
            return new int[]{nArray[n2]};
        }
        return nArray2[n2 - n];
    }

    private static final int getLabelLength(int n, int[][] nArray, int n2) {
        return n2 < n ? 1 : nArray[n2 - n].length;
    }

    private static final boolean isLabelAccepted(int n, int[] nArray, int n2, boolean[] blArray, boolean[] blArray2) {
        if (n2 < n) {
            return blArray[n2];
        }
        return blArray2[n2 - n];
    }

    private static final void markLabelAsRemoved(int n, int n2, boolean[] blArray, boolean[] blArray2) {
        if (n2 < n) {
            blArray[n2] = false;
        } else {
            blArray2[n2 - n] = false;
        }
    }

    private static final double calculateLabelOverride(int n, int[] nArray, int[] nArray2, int n2, int n3) {
        int n4 = n2 < n ? nArray[n2] : nArray2[n2 - n];
        int n5 = n3 < n ? nArray[n3] : nArray2[n3 - n];
        return (double)n4 / (double)n5;
    }

    static class LabelIndexWithCodes {
        private final int labelIndex;
        private final int[] codes;

        public LabelIndexWithCodes(int n, int[] nArray) {
            this.labelIndex = n;
            this.codes = nArray;
        }

        public int[] getCodes() {
            return this.codes;
        }

        public int getLabelIndex() {
            return this.labelIndex;
        }
    }
}

