/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class CompleteLabelFilterDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.text.preprocessing.filter.CompleteLabelFilter";
    public final String prefix = "CompleteLabelFilter";
    public final String title = "A filter that removes \"incomplete\" labels";
    public final String label = "";
    public final String description = "<p> See <a href=\"http://project.carrot2.org/publications/osinski-2003-lingo.pdf\">this document</a>, page 31 for a definition of a complete phrase.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(CompleteLabelFilterDescriptor.attributes.enabled);
        hashSet.add(CompleteLabelFilterDescriptor.attributes.labelOverrideThreshold);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(CompleteLabelFilterDescriptor.attributes.enabled);
        hashSet2.add(CompleteLabelFilterDescriptor.attributes.labelOverrideThreshold);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "CompleteLabelFilter";
    }

    public String getTitle() {
        return "A filter that removes \"incomplete\" labels";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "<p> See <a href=\"http://project.carrot2.org/publications/osinski-2003-lingo.pdf\">this document</a>, page 31 for a definition of a complete phrase.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder enabled(boolean bl) {
            this.map.put("CompleteLabelFilter.enabled", bl);
            return this;
        }

        public AttributeBuilder enabled(IObjectFactory<? extends Boolean> iObjectFactory) {
            this.map.put("CompleteLabelFilter.enabled", iObjectFactory);
            return this;
        }

        public AttributeBuilder labelOverrideThreshold(double d) {
            this.map.put("CompleteLabelFilter.labelOverrideThreshold", d);
            return this;
        }

        public AttributeBuilder labelOverrideThreshold(IObjectFactory<? extends Double> iObjectFactory) {
            this.map.put("CompleteLabelFilter.labelOverrideThreshold", iObjectFactory);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo enabled = new AttributeInfo("CompleteLabelFilter.enabled", "org.carrot2.text.preprocessing.filter.CompleteLabelFilter", "enabled", "Remove truncated phrases. Tries to remove \"incomplete\" cluster labels. For example,\nin a collection of documents related to <i>Data Mining</i>, the phrase\n<i>Conference on Data</i> is incomplete in a sense that most likely it should be\n<i>Conference on Data Mining</i> or even <i>Conference on Data Mining in Large\nDatabases</i>. When truncated phrase removal is enabled, the algorithm would try to\nremove the \"incomplete\" phrases like the former one and leave only the more\ninformative variants.", "Remove truncated phrases", "Remove truncated phrases", "Tries to remove \"incomplete\" cluster labels. For example, in a collection of documents related to <i>Data Mining</i>, the phrase <i>Conference on Data</i> is incomplete in a sense that most likely it should be <i>Conference on Data Mining</i> or even <i>Conference on Data Mining in Large Databases</i>. When truncated phrase removal is enabled, the algorithm would try to remove the \"incomplete\" phrases like the former one and leave only the more informative variants.", "Labels", AttributeLevel.BASIC, null);
        public final AttributeInfo labelOverrideThreshold = new AttributeInfo("CompleteLabelFilter.labelOverrideThreshold", "org.carrot2.text.preprocessing.filter.CompleteLabelFilter", "labelOverrideThreshold", "Truncated label threshold. Determines the strength of the truncated label filter.\nThe lowest value means strongest truncated labels elimination, which may lead to\noverlong cluster labels and many unclustered documents. The highest value\neffectively disables the filter, which may result in short or truncated labels.", "Truncated label threshold", "Truncated label threshold", "Determines the strength of the truncated label filter. The lowest value means strongest truncated labels elimination, which may lead to overlong cluster labels and many unclustered documents. The highest value effectively disables the filter, which may result in short or truncated labels.", "Labels", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys {
        public static final String ENABLED = "CompleteLabelFilter.enabled";
        public static final String LABEL_OVERRIDE_THRESHOLD = "CompleteLabelFilter.labelOverrideThreshold";

        protected Keys() {
        }
    }
}

