/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.core.attribute.Processing;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;

@Bindable(prefix="GenitiveLabelFilter")
public class GenitiveLabelFilter
extends SingleLabelFilterBase {
    @Input
    @Processing
    @Attribute
    @Label(value="Remove labels ending in genitive form")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Labels")
    public boolean enabled = true;
    private static final char[][] ENDINGS = new char[][]{"'s".toCharArray(), "`s".toCharArray(), "s'".toCharArray(), "s`".toCharArray()};

    @Override
    public boolean acceptPhrase(PreprocessingContext preprocessingContext, int n) {
        int[] nArray = preprocessingContext.allPhrases.wordIndices[n];
        return this.isGenitive(preprocessingContext.allWords.image, nArray[nArray.length - 1]);
    }

    @Override
    public boolean acceptWord(PreprocessingContext preprocessingContext, int n) {
        return this.isGenitive(preprocessingContext.allWords.image, n);
    }

    private boolean isGenitive(char[][] cArray, int n) {
        char[] cArray2 = cArray[n];
        char[][] cArray3 = ENDINGS;
        int n2 = ENDINGS.length;
        int n3 = 0;
        while (n3 < n2) {
            block4: {
                char[] cArray4 = cArray3[n3];
                if (cArray2.length >= cArray4.length) {
                    int n4 = 0;
                    while (n4 < cArray4.length) {
                        if (cArray2[cArray2.length - cArray4.length + n4] == cArray4[n4]) {
                            ++n4;
                            continue;
                        }
                        break block4;
                    }
                    return false;
                }
            }
            ++n3;
        }
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

