/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.core.attribute.Processing;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;

@Bindable(prefix="MinLengthLabelFilter")
public class MinLengthLabelFilter
extends SingleLabelFilterBase {
    @Input
    @Processing
    @Attribute
    @Label(value="Remove short labels")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Labels")
    public boolean enabled = true;
    private static final int MIN_LENGTH = 3;

    @Override
    public boolean acceptPhrase(PreprocessingContext preprocessingContext, int n) {
        int[] nArray = preprocessingContext.allPhrases.wordIndices[n];
        char[][] cArray = preprocessingContext.allWords.image;
        int n2 = 0;
        int n3 = cArray[nArray[n2++]].length;
        while (n3 < 3 && n2 < nArray.length) {
            n3 += cArray[nArray[n2]].length + 1;
            ++n2;
        }
        return n3 >= 3;
    }

    @Override
    public boolean acceptWord(PreprocessingContext preprocessingContext, int n) {
        return preprocessingContext.allWords.image[n].length >= 3;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

