/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.core.attribute.Processing;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;

@Bindable(prefix="NumericLabelFilter")
public class NumericLabelFilter
extends SingleLabelFilterBase {
    @Input
    @Processing
    @Attribute
    @Label(value="Remove numeric labels")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Labels")
    public boolean enabled = true;

    @Override
    public boolean acceptPhrase(PreprocessingContext preprocessingContext, int n) {
        short[] sArray = preprocessingContext.allWords.type;
        int[] nArray = preprocessingContext.allPhrases.wordIndices[n];
        return !this.isNumeric(sArray[nArray[0]]);
    }

    @Override
    public boolean acceptWord(PreprocessingContext preprocessingContext, int n) {
        return !this.isNumeric(preprocessingContext.allWords.type[n]);
    }

    private final boolean isNumeric(short s) {
        return (s & 0xF) == 2;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

