/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.core.attribute.Processing;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;

@Bindable(prefix="QueryLabelFilter")
public class QueryLabelFilter
extends SingleLabelFilterBase {
    @Input
    @Processing
    @Attribute
    @Label(value="Remove query words")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Labels")
    public boolean enabled = true;

    @Override
    public boolean acceptPhrase(PreprocessingContext preprocessingContext, int n) {
        int[] nArray = preprocessingContext.allPhrases.wordIndices[n];
        short[] sArray = preprocessingContext.allWords.type;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (!this.isQueryWord(sArray[nArray[n2]])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean acceptWord(PreprocessingContext preprocessingContext, int n) {
        return !this.isQueryWord(preprocessingContext.allWords.type[n]);
    }

    private final boolean isQueryWord(short s) {
        return (s & 0x2000) != 0;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

