/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.core.attribute.Processing;
import org.carrot2.text.linguistic.ILexicalData;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;

@Bindable(prefix="StopLabelFilter")
public class StopLabelFilter
extends SingleLabelFilterBase {
    @Input
    @Processing
    @Attribute
    @Label(value="Remove stop labels")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Labels")
    public boolean enabled = true;
    private final LabelFormatter labelFormatter = new LabelFormatter();
    private ILexicalData lexicalData;

    @Override
    public void filter(PreprocessingContext preprocessingContext, boolean[] blArray, boolean[] blArray2) {
        this.lexicalData = preprocessingContext.language.getLexicalData();
        super.filter(preprocessingContext, blArray, blArray2);
    }

    @Override
    public boolean acceptPhrase(PreprocessingContext preprocessingContext, int n) {
        String string = this.labelFormatter.format(preprocessingContext, n + preprocessingContext.allWords.image.length);
        return !this.lexicalData.isStopLabel(string);
    }

    @Override
    public boolean acceptWord(PreprocessingContext preprocessingContext, int n) {
        String string = this.labelFormatter.format(preprocessingContext, n);
        return !this.lexicalData.isStopLabel(string);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

