/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.core.attribute.Processing;
import org.carrot2.text.analysis.TokenTypeUtils;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Level;

@Bindable(prefix="StopWordLabelFilter")
public class StopWordLabelFilter
extends SingleLabelFilterBase {
    @Input
    @Processing
    @Attribute
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Labels")
    public boolean enabled = true;

    @Override
    public boolean acceptPhrase(PreprocessingContext preprocessingContext, int n) {
        short[] sArray = preprocessingContext.allWords.type;
        int[] nArray = preprocessingContext.allPhrases.wordIndices[n];
        return !TokenTypeUtils.isCommon(sArray[nArray[0]]) && !TokenTypeUtils.isCommon(sArray[nArray[nArray.length - 1]]);
    }

    @Override
    public boolean acceptWord(PreprocessingContext preprocessingContext, int n) {
        return !TokenTypeUtils.isCommon(preprocessingContext.allWords.type[n]);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

