/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.pipeline;

import java.util.List;
import org.carrot2.core.Document;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.text.linguistic.DefaultLexicalDataFactory;
import org.carrot2.text.linguistic.DefaultStemmerFactory;
import org.carrot2.text.linguistic.DefaultTokenizerFactory;
import org.carrot2.text.linguistic.ILexicalDataFactory;
import org.carrot2.text.linguistic.IStemmerFactory;
import org.carrot2.text.linguistic.ITokenizerFactory;
import org.carrot2.text.linguistic.LanguageModel;
import org.carrot2.text.preprocessing.CaseNormalizer;
import org.carrot2.text.preprocessing.LanguageModelStemmer;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.StopListMarker;
import org.carrot2.text.preprocessing.Tokenizer;
import org.carrot2.text.preprocessing.pipeline.IPreprocessingPipeline;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.constraint.ImplementingClasses;

@Bindable(prefix="PreprocessingPipeline")
public class BasicPreprocessingPipeline
implements IPreprocessingPipeline {
    public final Tokenizer tokenizer = new Tokenizer();
    public final CaseNormalizer caseNormalizer = new CaseNormalizer();
    public final LanguageModelStemmer languageModelStemmer = new LanguageModelStemmer();
    public final StopListMarker stopListMarker = new StopListMarker();
    @Input
    @Init
    @Processing
    @Internal
    @Attribute
    @ImplementingClasses(classes={}, strict=false)
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Preprocessing")
    public ITokenizerFactory tokenizerFactory = new DefaultTokenizerFactory();
    @Input
    @Init
    @Processing
    @Internal
    @Attribute
    @ImplementingClasses(classes={}, strict=false)
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Preprocessing")
    public IStemmerFactory stemmerFactory = new DefaultStemmerFactory();
    @Input
    @Init
    @Processing
    @Internal
    @Attribute
    @ImplementingClasses(classes={}, strict=false)
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Preprocessing")
    public ILexicalDataFactory lexicalDataFactory = new DefaultLexicalDataFactory();

    @Override
    public PreprocessingContext preprocess(List<Document> list, String string, LanguageCode languageCode) {
        PreprocessingContext preprocessingContext = new PreprocessingContext(LanguageModel.create(languageCode, this.stemmerFactory, this.tokenizerFactory, this.lexicalDataFactory), list, string);
        this.tokenizer.tokenize(preprocessingContext);
        this.caseNormalizer.normalize(preprocessingContext);
        this.languageModelStemmer.stem(preprocessingContext);
        this.stopListMarker.mark(preprocessingContext);
        preprocessingContext.preprocessingFinished();
        return preprocessingContext;
    }
}

