/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.pipeline;

import java.util.List;
import org.carrot2.core.Document;
import org.carrot2.core.LanguageCode;
import org.carrot2.text.linguistic.LanguageModel;
import org.carrot2.text.preprocessing.DocumentAssigner;
import org.carrot2.text.preprocessing.LabelFilterProcessor;
import org.carrot2.text.preprocessing.PhraseExtractor;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.pipeline.BasicPreprocessingPipeline;
import org.carrot2.util.attribute.Bindable;

@Bindable(prefix="PreprocessingPipeline")
public class CompletePreprocessingPipeline
extends BasicPreprocessingPipeline {
    public final PhraseExtractor phraseExtractor = new PhraseExtractor();
    public final LabelFilterProcessor labelFilterProcessor = new LabelFilterProcessor();
    public final DocumentAssigner documentAssigner = new DocumentAssigner();

    @Override
    public PreprocessingContext preprocess(List<Document> list, String string, LanguageCode languageCode) {
        PreprocessingContext preprocessingContext = new PreprocessingContext(LanguageModel.create(languageCode, this.stemmerFactory, this.tokenizerFactory, this.lexicalDataFactory), list, string);
        this.tokenizer.tokenize(preprocessingContext);
        this.caseNormalizer.normalize(preprocessingContext);
        this.languageModelStemmer.stem(preprocessingContext);
        this.stopListMarker.mark(preprocessingContext);
        this.phraseExtractor.extractPhrases(preprocessingContext);
        this.labelFilterProcessor.process(preprocessingContext);
        this.documentAssigner.assign(preprocessingContext);
        preprocessingContext.preprocessingFinished();
        return preprocessingContext;
    }
}

