/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.util;

import java.util.Arrays;

public final class MutableCharArray
implements CharSequence,
Cloneable {
    private static final char[] EMPTY = new char[0];
    private char[] buffer;
    private int length;
    private int start;
    private int hash;

    public MutableCharArray() {
        this.reset(EMPTY);
    }

    public MutableCharArray(CharSequence charSequence) {
        this.reset(charSequence);
    }

    public MutableCharArray(char[] cArray) {
        this.reset(cArray, 0, cArray.length);
    }

    public MutableCharArray(char[] cArray, int n, int n2) {
        this.reset(cArray, n, n2);
    }

    public void reset(CharSequence charSequence) {
        if (this.buffer == null || this.buffer.length < charSequence.length()) {
            this.buffer = new char[charSequence.length()];
        }
        this.length = charSequence.length();
        this.start = 0;
        int n = 0;
        while (n < this.length) {
            this.buffer[n] = charSequence.charAt(n);
            ++n;
        }
        this.hash = MutableCharArray.hashCode(this.buffer, this.start, this.length);
    }

    public void reset(char[] cArray) {
        this.reset(cArray, 0, cArray.length);
    }

    public void reset(char[] cArray, int n, int n2) {
        this.length = n2;
        this.start = n;
        this.buffer = cArray;
        this.hash = MutableCharArray.hashCode(cArray, n, n2);
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    public int getStart() {
        return this.start;
    }

    @Override
    public final char charAt(int n) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[this.start + n];
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public MutableCharArray subSequence(int n, int n2) {
        return new MutableCharArray(this.buffer, n, n2 - n);
    }

    @Override
    public String toString() {
        return new String(this.buffer, this.start, this.length);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MutableCharArray) {
            MutableCharArray mutableCharArray = (MutableCharArray)object;
            if (this.length == mutableCharArray.length && this.hashCode() == mutableCharArray.hashCode()) {
                int n = mutableCharArray.start;
                int n2 = this.start;
                int n3 = this.length - 1;
                while (n3 >= 0) {
                    if (mutableCharArray.buffer[n] != this.buffer[n2]) {
                        return false;
                    }
                    --n3;
                    ++n;
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    public static final int hashCode(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            n3 = 31 * n3 + cArray[n++];
            --n4;
        }
        return n3;
    }

    public MutableCharArray clone() {
        if (this.length == 0) {
            return new MutableCharArray();
        }
        char[] cArray = new char[this.length];
        System.arraycopy(this.buffer, this.start, cArray, 0, this.length);
        return new MutableCharArray(cArray);
    }

    public char[] toArray() {
        return Arrays.copyOfRange(this.getBuffer(), this.getStart(), this.length());
    }
}

