/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class TabularOutput {
    private String columnSeparator = " ";
    final List<ColumnSpec> columns = Lists.newArrayList();
    final HashMap<String, ColumnSpec> columnsByName = Maps.newHashMap();
    final List<Object> currentRow = Lists.newArrayList();
    final List<List<Object>> data = Lists.newArrayList();
    private Writer writer;
    private int flushCount = 1;
    private int rowCount;
    private boolean outputEmitted;
    private ArrayList<RowListener> listeners = new ArrayList();
    private final LinkedHashMap<Class<?>, ColumnSpec> defaultFormats = new LinkedHashMap();
    private boolean autoAddColumns;
    private boolean columnsChanged;

    public TabularOutput(Writer writer) {
        this.defaultFormats.put(Object.class, this.defaultFormat(Object.class).format("%s"));
        this.autoAddColumns = true;
        this.columnsChanged = false;
        this.writer = writer;
    }

    public TabularOutput() {
        this(new PrintWriter(System.out));
    }

    private Object toStringAdapters(Object object) {
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        return object;
    }

    public TabularOutput addListener(RowListener rowListener) {
        this.listeners.add(rowListener);
        return this;
    }

    ColumnSpec defaultSpec(Class<?> clazz) {
        ArrayList arrayList = new ArrayList(this.defaultFormats.entrySet());
        Collections.reverse(arrayList);
        for (Map.Entry<Class<?>, ColumnSpec> entry : arrayList) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            return entry.getValue();
        }
        throw new IllegalStateException("No default column spec?");
    }

    public ColumnSpec defaultFormat(Class<?> clazz) {
        ColumnSpec columnSpec = this.defaultFormats.get(clazz);
        if (columnSpec == null) {
            columnSpec = new ColumnSpec("default-" + clazz.getSimpleName(), -1);
            this.defaultFormats.put(clazz, columnSpec);
        }
        return columnSpec;
    }

    public ColumnSpec addColumn(String string) {
        if (!this.autoAddColumns) {
            this.checkNoDataAdded();
        }
        ColumnSpec columnSpec = new ColumnSpec(string, this.columns.size());
        this.columns.add(columnSpec);
        if (this.columnsByName.put(columnSpec.name, columnSpec) != null) {
            throw new IllegalArgumentException("Two columns with the same name: " + string);
        }
        this.columnsChanged = true;
        return columnSpec;
    }

    public TabularOutput columnSeparator(String string) {
        this.checkNoDataAdded();
        this.columnSeparator = string;
        return this;
    }

    public TabularOutput nextRow() {
        this.data.add(Lists.newArrayList(this.currentRow));
        this.currentRow.clear();
        if (++this.rowCount >= this.flushCount) {
            this.rowCount = 0;
            this.flush();
        }
        return this;
    }

    public TabularOutput rowData(Object ... objectArray) {
        if (this.currentRow.size() + objectArray.length > this.columns.size()) {
            throw new IllegalStateException("Row would be larger than the number of columns: " + this.columns.size() + ", row: " + this.currentRow.size() + " attempted add: " + objectArray.length);
        }
        this.currentRow.addAll(Arrays.asList(objectArray));
        return this;
    }

    public TabularOutput rowData(String string, Object object) {
        ColumnSpec columnSpec = this.columnsByName.get(string);
        if (columnSpec == null) {
            if (this.autoAddColumns) {
                columnSpec = this.addColumn(string);
            } else {
                throw new IllegalArgumentException("No such column: " + string);
            }
        }
        int n = columnSpec.index;
        while (n >= this.currentRow.size()) {
            this.currentRow.add(null);
        }
        this.currentRow.set(n, object);
        return this;
    }

    public TabularOutput flushEvery(int n) {
        this.flushCount = n;
        return this;
    }

    public TabularOutput flush() {
        try {
            return this.flush0();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private TabularOutput flush0() throws IOException {
        if (this.data.size() > 0) {
            String string;
            Object object;
            boolean bl = false;
            for (List<Object> list : this.data) {
                int n = 0;
                while (n < this.columns.size()) {
                    object = this.columns.get(n);
                    string = ((ColumnSpec)object).formatValue(n < list.size() ? list.get(n) : null);
                    bl |= ((ColumnSpec)object).updateWidth(string.length());
                    if (n >= list.size()) {
                        list.add(null);
                    }
                    ++n;
                }
            }
            if (bl || this.columnsChanged) {
                if (this.outputEmitted) {
                    this.writer.write("\n");
                }
                this.outputEmitted = true;
                int n = 0;
                while (n < this.columns.size()) {
                    ColumnSpec columnSpec = this.columns.get(n);
                    String string2 = columnSpec.align(columnSpec.name);
                    columnSpec.updateWidth(string2.length());
                    this.writer.write(string2);
                    this.writer.write(this.columnSeparator);
                    ++n;
                }
                this.writer.write("\n");
                this.columnsChanged = false;
            }
            for (List<Object> list : this.data) {
                for (RowListener rowListener : this.listeners) {
                    rowListener.newRow(this.columns, list);
                }
                int n = 0;
                while (n < list.size()) {
                    object = this.columns.get(n);
                    string = ((ColumnSpec)object).formatValue(n < list.size() ? list.get(n) : null);
                    this.writer.write(((ColumnSpec)object).align(string));
                    this.writer.write(this.columnSeparator);
                    ++n;
                }
                this.writer.write("\n");
            }
            this.data.clear();
            this.writer.flush();
        }
        return this;
    }

    private void checkNoDataAdded() {
        if (this.currentRow.size() != 0 || this.data.size() != 0) {
            throw new IllegalStateException("Data already added.");
        }
    }

    public List<ColumnSpec> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER;


        public String align(String string, int n) {
            switch (this) {
                case LEFT: {
                    return StringUtils.rightPad((String)string, (int)n);
                }
                case RIGHT: {
                    return StringUtils.leftPad((String)string, (int)n);
                }
            }
            return StringUtils.center((String)string, (int)n);
        }
    }

    public final class ColumnSpec {
        public final String name;
        private Alignment alignment;
        String format;
        int maxWidth;
        public final int index;

        public ColumnSpec(String string, int n) {
            this.name = string;
            this.index = n;
        }

        public TabularOutput tabularOutput() {
            return TabularOutput.this;
        }

        public ColumnSpec alignLeft() {
            TabularOutput.this.checkNoDataAdded();
            this.alignment = Alignment.LEFT;
            return this;
        }

        public ColumnSpec alignRight() {
            TabularOutput.this.checkNoDataAdded();
            this.alignment = Alignment.RIGHT;
            return this;
        }

        public ColumnSpec alignCenter() {
            TabularOutput.this.checkNoDataAdded();
            this.alignment = Alignment.CENTER;
            return this;
        }

        public String toString() {
            return this.name;
        }

        public ColumnSpec format(String string) {
            if (this.format != null) {
                throw new IllegalStateException("Format already initialized to: " + this.format);
            }
            if (string == null) {
                string = "%s";
            }
            this.format = string;
            return this;
        }

        boolean updateWidth(int n) {
            if (n > this.maxWidth) {
                this.maxWidth = n;
                return true;
            }
            return false;
        }

        private String formatValue(Object object) {
            String string;
            if (object == null) {
                string = "--";
            } else {
                object = TabularOutput.this.toStringAdapters(object);
                if (this.format == null) {
                    this.format(TabularOutput.this.defaultSpec(object.getClass()).format);
                }
                if (this.alignment == null) {
                    this.alignment = TabularOutput.this.defaultSpec(object.getClass()).alignment;
                }
                string = String.format(this.format, object);
            }
            return string;
        }

        public String align(String string) {
            Alignment alignment = this.alignment;
            if (alignment == null) {
                alignment = Alignment.RIGHT;
            }
            return alignment.align(string, this.maxWidth);
        }
    }

    public static interface RowListener {
        public void newRow(List<ColumnSpec> var1, List<Object> var2);
    }
}

