/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.vsm;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.text.vsm.ITermWeighting;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class TermDocumentMatrixBuilderDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.text.vsm.TermDocumentMatrixBuilder";
    public final String prefix = "TermDocumentMatrixBuilder";
    public final String title = "Builds a term document matrix based on the provided <code>PreprocessingContext</code>";
    public final String label = "";
    public final String description = "";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(TermDocumentMatrixBuilderDescriptor.attributes.maxWordDf);
        hashSet.add(TermDocumentMatrixBuilderDescriptor.attributes.maximumMatrixSize);
        hashSet.add(TermDocumentMatrixBuilderDescriptor.attributes.termWeighting);
        hashSet.add(TermDocumentMatrixBuilderDescriptor.attributes.titleWordsBoost);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(TermDocumentMatrixBuilderDescriptor.attributes.maxWordDf);
        hashSet2.add(TermDocumentMatrixBuilderDescriptor.attributes.maximumMatrixSize);
        hashSet2.add(TermDocumentMatrixBuilderDescriptor.attributes.termWeighting);
        hashSet2.add(TermDocumentMatrixBuilderDescriptor.attributes.titleWordsBoost);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "TermDocumentMatrixBuilder";
    }

    public String getTitle() {
        return "Builds a term document matrix based on the provided <code>PreprocessingContext</code>";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder maxWordDf(double d) {
            this.map.put("TermDocumentMatrixBuilder.maxWordDf", d);
            return this;
        }

        public AttributeBuilder maxWordDf(IObjectFactory<? extends Double> iObjectFactory) {
            this.map.put("TermDocumentMatrixBuilder.maxWordDf", iObjectFactory);
            return this;
        }

        public AttributeBuilder maximumMatrixSize(int n) {
            this.map.put("TermDocumentMatrixBuilder.maximumMatrixSize", n);
            return this;
        }

        public AttributeBuilder maximumMatrixSize(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("TermDocumentMatrixBuilder.maximumMatrixSize", iObjectFactory);
            return this;
        }

        public AttributeBuilder termWeighting(ITermWeighting iTermWeighting) {
            this.map.put("TermDocumentMatrixBuilder.termWeighting", iTermWeighting);
            return this;
        }

        public AttributeBuilder termWeighting(Class<?> clazz) {
            this.map.put("TermDocumentMatrixBuilder.termWeighting", clazz);
            return this;
        }

        public AttributeBuilder termWeighting(IObjectFactory<? extends ITermWeighting> iObjectFactory) {
            this.map.put("TermDocumentMatrixBuilder.termWeighting", iObjectFactory);
            return this;
        }

        public AttributeBuilder titleWordsBoost(double d) {
            this.map.put("TermDocumentMatrixBuilder.titleWordsBoost", d);
            return this;
        }

        public AttributeBuilder titleWordsBoost(IObjectFactory<? extends Double> iObjectFactory) {
            this.map.put("TermDocumentMatrixBuilder.titleWordsBoost", iObjectFactory);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo maxWordDf = new AttributeInfo("TermDocumentMatrixBuilder.maxWordDf", "org.carrot2.text.vsm.TermDocumentMatrixBuilder", "maxWordDf", "Maximum word document frequency. The maximum document frequency allowed for words\nas a fraction of all documents. Words with document frequency larger than\n<code>maxWordDf</code> will be ignored. For example, when <code>maxWordDf</code> is\n<code>0.4</code>, words appearing in more than 40% of documents will be be ignored.\nA value of <code>1.0</code> means that all words will be taken into\naccount, no matter in how many documents they appear.\n<p>\nThis attribute may be useful when certain words appear in most of the input\ndocuments (e.g. company name from header or footer) and such words dominate the\ncluster labels. In such case, setting <code>maxWordDf</code> to a value lower than\n<code>1.0</code>, e.g. <code>0.9</code> may improve the clusters. \n</p>\n<p>\nAnother useful application of this attribute is when there is a need to generate\nonly very specific clusters, i.e. clusters containing small numbers of documents.\nThis can be achieved by setting <code>maxWordDf</code> to extremely low values,\ne.g. <code>0.1</code> or <code>0.05</code>.\n</p>", null, "Maximum word document frequency", "The maximum document frequency allowed for words as a fraction of all documents. Words with document frequency larger than <code>maxWordDf</code> will be ignored. For example, when <code>maxWordDf</code> is <code>0.4</code>, words appearing in more than 40% of documents will be be ignored. A value of <code>1.0</code> means that all words will be taken into account, no matter in how many documents they appear. <p> This attribute may be useful when certain words appear in most of the input documents (e.g. company name from header or footer) and such words dominate the cluster labels. In such case, setting <code>maxWordDf</code> to a value lower than <code>1.0</code>, e.g. <code>0.9</code> may improve the clusters. </p> <p> Another useful application of this attribute is when there is a need to generate only very specific clusters, i.e. clusters containing small numbers of documents. This can be achieved by setting <code>maxWordDf</code> to extremely low values, e.g. <code>0.1</code> or <code>0.05</code>. </p>", "Matrix model", AttributeLevel.ADVANCED, null);
        public final AttributeInfo maximumMatrixSize = new AttributeInfo("TermDocumentMatrixBuilder.maximumMatrixSize", "org.carrot2.text.vsm.TermDocumentMatrixBuilder", "maximumMatrixSize", "Maximum matrix size. The maximum number of the term-document matrix elements. The\nlarger the size, the more accurate, time- and memory-consuming clustering.", null, "Maximum matrix size", "The maximum number of the term-document matrix elements. The larger the size, the more accurate, time- and memory-consuming clustering.", "Matrix model", AttributeLevel.ADVANCED, null);
        public final AttributeInfo termWeighting = new AttributeInfo("TermDocumentMatrixBuilder.termWeighting", "org.carrot2.text.vsm.TermDocumentMatrixBuilder", "termWeighting", "Term weighting. The method for calculating weight of words in the term-document\nmatrices.", null, "Term weighting", "The method for calculating weight of words in the term-document matrices.", "Matrix model", AttributeLevel.ADVANCED, null);
        public final AttributeInfo titleWordsBoost = new AttributeInfo("TermDocumentMatrixBuilder.titleWordsBoost", "org.carrot2.text.vsm.TermDocumentMatrixBuilder", "titleWordsBoost", "Title word boost. Gives more weight to words that appeared in\n{@link org.carrot2.core.Document#TITLE} fields.", null, "Title word boost", "Gives more weight to words that appeared in <code>org.carrot2.core.Document.TITLE</code> fields.", "Labels", AttributeLevel.MEDIUM, null);

        private Attributes() {
        }
    }

    public static class Keys {
        public static final String MAX_WORD_DF = "TermDocumentMatrixBuilder.maxWordDf";
        public static final String MAXIMUM_MATRIX_SIZE = "TermDocumentMatrixBuilder.maximumMatrixSize";
        public static final String TERM_WEIGHTING = "TermDocumentMatrixBuilder.termWeighting";
        public static final String TITLE_WORDS_BOOST = "TermDocumentMatrixBuilder.titleWordsBoost";

        protected Keys() {
        }
    }
}

