/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix;

import com.carrotsearch.hppc.sorting.IndirectComparator;
import com.carrotsearch.hppc.sorting.IndirectSort;
import java.util.Arrays;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.IntIntDoubleFunction;
import org.apache.mahout.math.matrix.DoubleMatrix2D;

public class MatrixUtils {
    public static DoubleMatrix2D normalizeColumnL2(DoubleMatrix2D doubleMatrix2D, double[] dArray) {
        dArray = MatrixUtils.prepareWork(doubleMatrix2D, dArray);
        int n = 0;
        while (n < doubleMatrix2D.rows()) {
            int n2 = 0;
            while (n2 < doubleMatrix2D.columns()) {
                int n3 = n2;
                dArray[n3] = dArray[n3] + doubleMatrix2D.getQuick(n, n2) * doubleMatrix2D.getQuick(n, n2);
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < doubleMatrix2D.columns()) {
            dArray[n] = Math.sqrt(dArray[n]);
            ++n;
        }
        MatrixUtils.normalizeColumns(doubleMatrix2D, dArray);
        return doubleMatrix2D;
    }

    public static DoubleMatrix2D normalizeSparseColumnL2(final DoubleMatrix2D doubleMatrix2D, double[] dArray) {
        final double[] dArray2 = MatrixUtils.prepareWork(doubleMatrix2D, dArray);
        doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int n, int n2, double d) {
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + d * d;
                return d;
            }
        });
        int n = 0;
        while (n < doubleMatrix2D.columns()) {
            dArray2[n] = Math.sqrt(dArray2[n]);
            ++n;
        }
        doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int n, int n2, double d) {
                doubleMatrix2D.setQuick(n, n2, d / dArray2[n2]);
                return 0.0;
            }
        });
        return doubleMatrix2D;
    }

    public static DoubleMatrix2D normalizeColumnL1(DoubleMatrix2D doubleMatrix2D, double[] dArray) {
        dArray = MatrixUtils.prepareWork(doubleMatrix2D, dArray);
        int n = 0;
        while (n < doubleMatrix2D.rows()) {
            int n2 = 0;
            while (n2 < doubleMatrix2D.columns()) {
                int n3 = n2;
                dArray[n3] = dArray[n3] + doubleMatrix2D.getQuick(n, n2);
                ++n2;
            }
            ++n;
        }
        MatrixUtils.normalizeColumns(doubleMatrix2D, dArray);
        return doubleMatrix2D;
    }

    private static double[] prepareWork(DoubleMatrix2D doubleMatrix2D, double[] dArray) {
        if (dArray == null || dArray.length != doubleMatrix2D.columns()) {
            dArray = new double[doubleMatrix2D.columns()];
        } else {
            Arrays.fill(dArray, 0.0);
        }
        return dArray;
    }

    private static void normalizeColumns(DoubleMatrix2D doubleMatrix2D, double[] dArray) {
        int n = doubleMatrix2D.rows() - 1;
        while (n >= 0) {
            int n2 = 0;
            while (n2 < doubleMatrix2D.columns()) {
                if (dArray[n2] != 0.0) {
                    doubleMatrix2D.setQuick(n, n2, doubleMatrix2D.getQuick(n, n2) / dArray[n2]);
                }
                ++n2;
            }
            --n;
        }
    }

    public static double computeOrthogonality(DoubleMatrix2D doubleMatrix2D) {
        double d = 0.0;
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.zMult(doubleMatrix2D, null, 1.0, 0.0, true, false);
        int n = 0;
        while (n < doubleMatrix2D2.rows()) {
            int n2 = n + 1;
            while (n2 < doubleMatrix2D2.columns()) {
                d += doubleMatrix2D2.getQuick(n, n2);
                ++n2;
            }
            ++n;
        }
        return d / ((double)((doubleMatrix2D2.rows() - 1) * doubleMatrix2D2.rows()) / 2.0);
    }

    public static double computeSparseness(DoubleMatrix2D doubleMatrix2D) {
        int n = 0;
        int n2 = 0;
        while (n2 < doubleMatrix2D.rows()) {
            int n3 = 0;
            while (n3 < doubleMatrix2D.columns()) {
                if (doubleMatrix2D.getQuick(n2, n3) != 0.0) {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        return (double)n / (double)(doubleMatrix2D.rows() * doubleMatrix2D.columns());
    }

    public static int[] minInColumns(DoubleMatrix2D doubleMatrix2D, int[] nArray, double[] dArray) {
        return MatrixUtils.inColumns(doubleMatrix2D, nArray, dArray, DoubleComparators.REVERSED_ORDER, Functions.IDENTITY);
    }

    public static int[] maxInColumns(DoubleMatrix2D doubleMatrix2D, int[] nArray, double[] dArray) {
        return MatrixUtils.maxInColumns(doubleMatrix2D, nArray, dArray, Functions.IDENTITY);
    }

    public static int[] maxInColumns(DoubleMatrix2D doubleMatrix2D, int[] nArray, double[] dArray, DoubleFunction doubleFunction) {
        return MatrixUtils.inColumns(doubleMatrix2D, nArray, dArray, DoubleComparators.NATURAL_ORDER, doubleFunction);
    }

    private static int[] inColumns(DoubleMatrix2D doubleMatrix2D, int[] nArray, double[] dArray, DoubleComparator doubleComparator, DoubleFunction doubleFunction) {
        if (nArray == null) {
            nArray = new int[doubleMatrix2D.columns()];
        }
        if (doubleMatrix2D.columns() == 0 || doubleMatrix2D.rows() == 0) {
            return nArray;
        }
        if (dArray == null) {
            dArray = new double[doubleMatrix2D.columns()];
        }
        int n = 0;
        while (n < doubleMatrix2D.columns()) {
            dArray[n] = doubleFunction.apply(doubleMatrix2D.getQuick(0, n));
            ++n;
        }
        Arrays.fill(nArray, 0);
        n = 1;
        while (n < doubleMatrix2D.rows()) {
            int n2 = 0;
            while (n2 < doubleMatrix2D.columns()) {
                double d = doubleFunction.apply(doubleMatrix2D.getQuick(n, n2));
                if (doubleComparator.compare(d, dArray[n2]) > 0) {
                    dArray[n2] = d;
                    nArray[n2] = n;
                }
                ++n2;
            }
            ++n;
        }
        return nArray;
    }

    public static int maxInRow(DoubleMatrix2D doubleMatrix2D, int n) {
        int n2 = 0;
        double d = doubleMatrix2D.getQuick(n, n2);
        int n3 = 1;
        while (n3 < doubleMatrix2D.columns()) {
            if (d < doubleMatrix2D.getQuick(n, n3)) {
                d = doubleMatrix2D.getQuick(n, n3);
                n2 = n3;
            }
            ++n3;
        }
        return n2;
    }

    public static double[] sumRows(DoubleMatrix2D doubleMatrix2D, double[] dArray) {
        if (dArray == null || doubleMatrix2D.rows() != dArray.length) {
            dArray = new double[doubleMatrix2D.rows()];
        } else {
            Arrays.fill(dArray, 0.0);
        }
        int n = 0;
        while (n < doubleMatrix2D.rows()) {
            int n2 = 0;
            while (n2 < doubleMatrix2D.columns()) {
                int n3 = n;
                dArray[n3] = dArray[n3] + doubleMatrix2D.getQuick(n, n2);
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    public static double frobeniusNorm(DoubleMatrix2D doubleMatrix2D) {
        return Math.sqrt(doubleMatrix2D.aggregate(Functions.PLUS, Functions.SQUARE));
    }

    public static DoubleMatrix2D sortedRowsView(DoubleMatrix2D doubleMatrix2D, IndirectComparator indirectComparator) {
        return doubleMatrix2D.viewSelection(IndirectSort.mergesort((int)0, (int)doubleMatrix2D.rows(), (IndirectComparator)indirectComparator), null);
    }

    private static interface DoubleComparator {
        public int compare(double var1, double var3);
    }

    private static final class DoubleComparators {
        public static final DoubleComparator NATURAL_ORDER = new NaturalOrderDoubleComparator();
        public static final DoubleComparator REVERSED_ORDER = new ReversedOrderDoubleComparator();

        private DoubleComparators() {
        }

        private static class NaturalOrderDoubleComparator
        implements DoubleComparator {
            private NaturalOrderDoubleComparator() {
            }

            @Override
            public int compare(double d, double d2) {
                return Double.compare(d, d2);
            }
        }

        private static class ReversedOrderDoubleComparator
        implements DoubleComparator {
            private ReversedOrderDoubleComparator() {
            }

            @Override
            public int compare(double d, double d2) {
                return -Double.compare(d, d2);
            }
        }
    }
}

