/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.matrix.factorization.IterativeMatrixFactorizationFactory;
import org.carrot2.matrix.factorization.LocalNonnegativeMatrixFactorizationFactory;
import org.carrot2.matrix.factorization.NonnegativeMatrixFactorizationEDFactory;
import org.carrot2.matrix.factorization.NonnegativeMatrixFactorizationKLFactory;
import org.carrot2.matrix.factorization.seeding.KMeansSeedingStrategyFactory;
import org.carrot2.matrix.factorization.seeding.RandomSeedingStrategyFactory;

public class IterationNumberGuesser {
    private static Map<List<Object>, double[]> allKnownCoefficients = Maps.newHashMap();

    static {
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.LOW}), new double[]{-0.0166, 0.3333, 8.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.MEDIUM}), new double[]{-0.0175, 0.6, 12.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.HIGH}), new double[]{-0.0186, 0.8222, 17.3555});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationKLFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.LOW}), new double[]{-0.0166, 0.3333, 8.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationKLFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.MEDIUM}), new double[]{-0.0175, 0.6, 12.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationKLFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.HIGH}), new double[]{-0.0186, 0.8222, 17.3555});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, KMeansSeedingStrategyFactory.class, FactorizationQuality.LOW}), new double[]{-0.005, 0.0, 6.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, KMeansSeedingStrategyFactory.class, FactorizationQuality.MEDIUM}), new double[]{-0.005, 0.0, 10.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, KMeansSeedingStrategyFactory.class, FactorizationQuality.HIGH}), new double[]{-0.005, 0.0, 20.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{LocalNonnegativeMatrixFactorizationFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.LOW}), new double[]{-0.014, 0.1, 7.5});
        allKnownCoefficients.put(Arrays.asList(new Object[]{LocalNonnegativeMatrixFactorizationFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.MEDIUM}), new double[]{-0.0175, 0.15, 11.3333});
        allKnownCoefficients.put(Arrays.asList(new Object[]{LocalNonnegativeMatrixFactorizationFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.HIGH}), new double[]{-0.02333, 0.2, 16.8888});
    }

    public static boolean setEstimatedIterationsNumber(IterativeMatrixFactorizationFactory iterativeMatrixFactorizationFactory, DoubleMatrix2D doubleMatrix2D, FactorizationQuality factorizationQuality) {
        double[] dArray = allKnownCoefficients.get(Arrays.asList(new Object[]{iterativeMatrixFactorizationFactory.getClass(), iterativeMatrixFactorizationFactory.getSeedingFactory().getClass(), factorizationQuality}));
        if (dArray != null) {
            double d = Math.sqrt((double)(doubleMatrix2D.rows() * doubleMatrix2D.columns()) / 2.8);
            if (d < 50.0 || d > 400.0 || iterativeMatrixFactorizationFactory.getK() < 5 || iterativeMatrixFactorizationFactory.getK() > 50) {
                return false;
            }
            int n = (int)(d * dArray[0] + (double)iterativeMatrixFactorizationFactory.getK() * dArray[1] + dArray[2]);
            iterativeMatrixFactorizationFactory.setMaxIterations((int)((double)n * 0.6));
            return true;
        }
        return false;
    }

    public static enum FactorizationQuality {
        LOW,
        MEDIUM,
        HIGH;


        public String toString() {
            return StringUtils.capitalize((String)this.name().toLowerCase());
        }
    }
}

