/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import com.carrotsearch.hppc.sorting.IndirectComparator;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.matrix.MatrixUtils;
import org.carrot2.matrix.factorization.IIterativeMatrixFactorization;
import org.carrot2.matrix.factorization.MatrixFactorizationBase;
import org.carrot2.matrix.factorization.seeding.ISeedingStrategy;
import org.carrot2.matrix.factorization.seeding.RandomSeedingStrategy;

abstract class IterativeMatrixFactorizationBase
extends MatrixFactorizationBase
implements IIterativeMatrixFactorization {
    protected int k = DEFAULT_K;
    protected static int DEFAULT_K = 15;
    protected int maxIterations = 15;
    protected static final int DEFAULT_MAX_ITERATIONS = 15;
    protected double stopThreshold = DEFAULT_STOP_THRESHOLD;
    protected static double DEFAULT_STOP_THRESHOLD = -1.0;
    protected ISeedingStrategy seedingStrategy = DEFAULT_SEEDING_STRATEGY;
    protected static final ISeedingStrategy DEFAULT_SEEDING_STRATEGY = new RandomSeedingStrategy(0);
    protected boolean ordered = false;
    protected static final boolean DEFAULT_ORDERED = false;
    protected double approximationError = -1.0;
    protected double[] approximationErrors = null;
    protected int iterationsCompleted = 0;
    protected double[] aggregates;

    public IterativeMatrixFactorizationBase(DoubleMatrix2D doubleMatrix2D) {
        super(doubleMatrix2D);
    }

    public void setK(int n) {
        this.k = n;
    }

    public int getK() {
        return this.k;
    }

    protected boolean updateApproximationError() {
        double d;
        if (this.approximationErrors == null) {
            this.approximationErrors = new double[this.maxIterations + 1];
        }
        this.approximationErrors[this.iterationsCompleted] = d = MatrixUtils.frobeniusNorm(this.U.zMult(this.V, null, 1.0, 0.0, false, true).assign(this.A, Functions.MINUS));
        if ((this.approximationError - d) / this.approximationError < this.stopThreshold) {
            this.approximationError = d;
            return true;
        }
        this.approximationError = d;
        return false;
    }

    protected void order() {
        DoubleMatrix2D doubleMatrix2D = this.V.viewDice();
        this.aggregates = new double[doubleMatrix2D.rows()];
        int n = 0;
        while (n < this.aggregates.length) {
            this.aggregates[n] = doubleMatrix2D.viewRow(n).aggregate(Functions.PLUS, Functions.SQUARE);
            ++n;
        }
        IndirectComparator.DescendingDoubleComparator descendingDoubleComparator = new IndirectComparator.DescendingDoubleComparator(this.aggregates);
        this.V = MatrixUtils.sortedRowsView(doubleMatrix2D, (IndirectComparator)descendingDoubleComparator).viewDice();
        this.U = MatrixUtils.sortedRowsView(this.U.viewDice(), (IndirectComparator)descendingDoubleComparator).viewDice();
    }

    public ISeedingStrategy getSeedingStrategy() {
        return this.seedingStrategy;
    }

    public void setSeedingStrategy(ISeedingStrategy iSeedingStrategy) {
        this.seedingStrategy = iSeedingStrategy;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int n) {
        this.maxIterations = n;
    }

    public double getStopThreshold() {
        return this.stopThreshold;
    }

    public void setStopThreshold(double d) {
        this.stopThreshold = d;
    }

    @Override
    public double getApproximationError() {
        return this.approximationError;
    }

    public double[] getApproximationErrors() {
        return this.approximationErrors;
    }

    @Override
    public int getIterationsCompleted() {
        return this.iterationsCompleted;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean bl) {
        this.ordered = bl;
    }

    public double[] getAggregates() {
        return this.aggregates;
    }
}

