/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.Mult;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.DenseDoubleMatrix2D;
import org.carrot2.matrix.MatrixUtils;
import org.carrot2.matrix.factorization.IterativeMatrixFactorizationBase;

public class KMeansMatrixFactorization
extends IterativeMatrixFactorizationBase {
    public KMeansMatrixFactorization(DoubleMatrix2D doubleMatrix2D) {
        super(doubleMatrix2D);
    }

    @Override
    public void compute() {
        int n = this.A.columns();
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(this.k, n);
        this.V = new DenseDoubleMatrix2D(n, this.k);
        this.U = new DenseDoubleMatrix2D(this.A.rows(), this.k);
        this.U.assign(this.A.viewPart(0, 0, this.A.rows(), this.k));
        int[] nArray = new int[denseDoubleMatrix2D.columns()];
        double[] dArray = new double[denseDoubleMatrix2D.columns()];
        this.iterationsCompleted = 0;
        while (this.iterationsCompleted < this.maxIterations) {
            this.U.zMult(this.A, (DoubleMatrix2D)denseDoubleMatrix2D, 1.0, 0.0, true, false);
            this.V.assign(0.0);
            this.U.assign(0.0);
            MatrixUtils.maxInColumns((DoubleMatrix2D)denseDoubleMatrix2D, nArray, dArray);
            int n2 = 0;
            while (n2 < nArray.length) {
                this.V.setQuick(n2, nArray[n2], 1.0);
                ++n2;
            }
            n2 = 0;
            while (n2 < this.V.columns()) {
                int n3 = 0;
                int n4 = 0;
                while (n4 < this.V.rows()) {
                    if (this.V.getQuick(n4, n2) != 0.0) {
                        ++n3;
                        this.U.viewColumn(n2).assign(this.A.viewColumn(n4), Functions.PLUS);
                    }
                    ++n4;
                }
                this.U.viewColumn(n2).assign((DoubleFunction)Mult.div((double)n3));
                MatrixUtils.normalizeColumnL2(this.U, null);
                ++n2;
            }
            ++this.iterationsCompleted;
        }
    }

    public String toString() {
        return "KMMF";
    }
}

