/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.DenseDoubleMatrix2D;
import org.carrot2.matrix.MatrixUtils;
import org.carrot2.matrix.factorization.IterativeMatrixFactorizationBase;

public class LocalNonnegativeMatrixFactorization
extends IterativeMatrixFactorizationBase {
    public LocalNonnegativeMatrixFactorization(DoubleMatrix2D doubleMatrix2D) {
        super(doubleMatrix2D);
    }

    @Override
    public void compute() {
        double d = 1.0E-9;
        this.U = new DenseDoubleMatrix2D(this.A.rows(), this.k);
        this.V = new DenseDoubleMatrix2D(this.A.columns(), this.k);
        this.seedingStrategy.seed(this.A, this.U, this.V);
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        doubleMatrix2D.assign(Functions.plus((double)d));
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(this.A.rows(), this.A.columns());
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(this.A.columns(), this.k);
        DenseDoubleMatrix2D denseDoubleMatrix2D3 = new DenseDoubleMatrix2D(this.A.rows(), this.k);
        double[] dArray = new double[this.U.columns()];
        DoubleDoubleFunction doubleDoubleFunction = Functions.swapArgs((DoubleDoubleFunction)Functions.DIV);
        DoubleDoubleFunction doubleDoubleFunction2 = Functions.chain((DoubleFunction)Functions.SQRT, (DoubleDoubleFunction)Functions.MULT);
        DoubleFunction doubleFunction = Functions.plus((double)d);
        if (this.stopThreshold >= 0.0) {
            this.updateApproximationError();
        }
        int n = 0;
        while (n < this.maxIterations) {
            this.U.zMult(this.V, (DoubleMatrix2D)denseDoubleMatrix2D, 1.0, 0.0, false, true);
            denseDoubleMatrix2D.assign(doubleFunction);
            denseDoubleMatrix2D.assign(doubleMatrix2D, doubleDoubleFunction);
            denseDoubleMatrix2D.zMult(this.U, (DoubleMatrix2D)denseDoubleMatrix2D2, 1.0, 0.0, true, false);
            this.V.assign((DoubleMatrix2D)denseDoubleMatrix2D2, doubleDoubleFunction2);
            this.U.zMult(this.V, (DoubleMatrix2D)denseDoubleMatrix2D, 1.0, 0.0, false, true);
            denseDoubleMatrix2D.assign(doubleFunction);
            denseDoubleMatrix2D.assign(doubleMatrix2D, doubleDoubleFunction);
            denseDoubleMatrix2D.zMult(this.V, (DoubleMatrix2D)denseDoubleMatrix2D3, 1.0, 0.0, false, false);
            this.U.assign((DoubleMatrix2D)denseDoubleMatrix2D3, Functions.MULT);
            MatrixUtils.normalizeColumnL1(this.U, dArray);
            ++this.iterationsCompleted;
            if (this.stopThreshold >= 0.0 && this.updateApproximationError()) break;
            ++n;
        }
        if (this.ordered) {
            this.order();
        }
    }

    public String toString() {
        return "LNMF-" + this.seedingStrategy.toString();
    }
}

