/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.DenseDoubleMatrix2D;
import org.carrot2.matrix.MatrixUtils;
import org.carrot2.matrix.factorization.IterativeMatrixFactorizationBase;

public class NonnegativeMatrixFactorizationKL
extends IterativeMatrixFactorizationBase {
    public NonnegativeMatrixFactorizationKL(DoubleMatrix2D doubleMatrix2D) {
        super(doubleMatrix2D);
    }

    @Override
    public void compute() {
        int n = this.A.rows();
        int n2 = this.A.columns();
        double d = 1.0E-9;
        this.U = new DenseDoubleMatrix2D(n, this.k);
        this.V = new DenseDoubleMatrix2D(n2, this.k);
        this.seedingStrategy.seed(this.A, this.U, this.V);
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        doubleMatrix2D.assign(Functions.plus((double)d));
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n, n2);
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(n2, this.k);
        DenseDoubleMatrix2D denseDoubleMatrix2D3 = new DenseDoubleMatrix2D(n, this.k);
        double[] dArray = new double[this.U.columns()];
        DoubleDoubleFunction doubleDoubleFunction = Functions.swapArgs((DoubleDoubleFunction)Functions.DIV);
        DoubleFunction doubleFunction = Functions.plus((double)d);
        if (this.stopThreshold >= 0.0) {
            this.updateApproximationError();
        }
        int n3 = 0;
        while (n3 < this.maxIterations) {
            this.U.zMult(this.V, (DoubleMatrix2D)denseDoubleMatrix2D, 1.0, 0.0, false, true);
            denseDoubleMatrix2D.assign(doubleFunction);
            denseDoubleMatrix2D.assign(doubleMatrix2D, doubleDoubleFunction);
            denseDoubleMatrix2D.zMult(this.U, (DoubleMatrix2D)denseDoubleMatrix2D2, 1.0, 0.0, true, false);
            this.V.assign((DoubleMatrix2D)denseDoubleMatrix2D2, Functions.MULT);
            this.U.zMult(this.V, (DoubleMatrix2D)denseDoubleMatrix2D, 1.0, 0.0, false, true);
            denseDoubleMatrix2D.assign(doubleFunction);
            denseDoubleMatrix2D.assign(doubleMatrix2D, doubleDoubleFunction);
            denseDoubleMatrix2D.zMult(this.V, (DoubleMatrix2D)denseDoubleMatrix2D3, 1.0, 0.0, false, false);
            this.U.assign((DoubleMatrix2D)denseDoubleMatrix2D3, Functions.MULT);
            MatrixUtils.normalizeColumnL1(this.U, dArray);
            ++this.iterationsCompleted;
            if (this.stopThreshold >= 0.0 && this.updateApproximationError()) break;
            ++n3;
        }
        if (this.ordered) {
            this.order();
        }
    }

    public String toString() {
        return "NMF-KL-" + this.seedingStrategy.toString();
    }
}

