/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import java.util.Arrays;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SingularValueDecomposition;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.DenseDoubleMatrix2D;
import org.carrot2.matrix.factorization.IMatrixFactorization;
import org.carrot2.matrix.factorization.MatrixFactorizationBase;

public class PartialSingularValueDecomposition
extends MatrixFactorizationBase
implements IMatrixFactorization {
    protected int k = -1;
    protected static final int DEFAULT_K = -1;
    private double[] S;

    public PartialSingularValueDecomposition(DoubleMatrix2D doubleMatrix2D) {
        super(doubleMatrix2D);
    }

    @Override
    public void compute() {
        SingularValueDecomposition singularValueDecomposition;
        if (this.A.columns() > this.A.rows()) {
            singularValueDecomposition = new SingularValueDecomposition((Matrix)new DenseMatrix(this.A.viewDice().toArray()));
            this.V = PartialSingularValueDecomposition.toColtMatrix(singularValueDecomposition.getU());
            this.U = PartialSingularValueDecomposition.toColtMatrix(singularValueDecomposition.getV());
        } else {
            singularValueDecomposition = new SingularValueDecomposition((Matrix)new DenseMatrix(this.A.toArray()));
            this.U = PartialSingularValueDecomposition.toColtMatrix(singularValueDecomposition.getU());
            this.V = PartialSingularValueDecomposition.toColtMatrix(singularValueDecomposition.getV());
        }
        this.S = singularValueDecomposition.getSingularValues();
        if (this.k > 0 && this.k < this.S.length) {
            this.U = this.U.viewPart(0, 0, this.U.rows(), this.k);
            this.V = this.V.viewPart(0, 0, this.V.rows(), this.k);
            this.S = Arrays.copyOf(this.S, this.k);
        }
    }

    private static DenseDoubleMatrix2D toColtMatrix(Matrix matrix) {
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(matrix.rowSize(), matrix.columnSize());
        int n = 0;
        while (n < denseDoubleMatrix2D.rows()) {
            int n2 = 0;
            while (n2 < denseDoubleMatrix2D.columns()) {
                denseDoubleMatrix2D.setQuick(n, n2, matrix.getQuick(n, n2));
                ++n2;
            }
            ++n;
        }
        return denseDoubleMatrix2D;
    }

    public String toString() {
        return "SVD";
    }

    public double[] getSingularValues() {
        return this.S;
    }

    public void setK(int n) {
        this.k = n;
    }

    public int getK() {
        return this.k;
    }
}

