/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization.seeding;

import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.matrix.factorization.KMeansMatrixFactorization;
import org.carrot2.matrix.factorization.seeding.ISeedingStrategy;

public class KMeansSeedingStrategy
implements ISeedingStrategy {
    private int maxIterations;
    private static final int DEFAULT_MAX_ITERATIONS = 5;

    public KMeansSeedingStrategy() {
        this(5);
    }

    public KMeansSeedingStrategy(int n) {
        this.maxIterations = n;
    }

    @Override
    public void seed(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, DoubleMatrix2D doubleMatrix2D3) {
        int n;
        KMeansMatrixFactorization kMeansMatrixFactorization = new KMeansMatrixFactorization(doubleMatrix2D);
        kMeansMatrixFactorization.setK(doubleMatrix2D2.columns());
        kMeansMatrixFactorization.setMaxIterations(this.maxIterations);
        kMeansMatrixFactorization.compute();
        doubleMatrix2D2.assign(kMeansMatrixFactorization.getU());
        int n2 = 0;
        while (n2 < doubleMatrix2D2.rows()) {
            n = 0;
            while (n < doubleMatrix2D2.columns()) {
                if (doubleMatrix2D2.getQuick(n2, n) < 0.001) {
                    doubleMatrix2D2.setQuick(n2, n, 0.05);
                }
                ++n;
            }
            ++n2;
        }
        doubleMatrix2D3.assign(kMeansMatrixFactorization.getV());
        n2 = 0;
        while (n2 < doubleMatrix2D3.rows()) {
            n = 0;
            while (n < doubleMatrix2D3.columns()) {
                if (doubleMatrix2D3.getQuick(n2, n) == 0.0) {
                    doubleMatrix2D3.setQuick(n2, n, 0.05);
                }
                ++n;
            }
            ++n2;
        }
    }

    public String toString() {
        return "KM";
    }
}

