/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization.seeding;

import java.util.Random;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.matrix.factorization.seeding.ISeedingStrategy;

public class RandomSeedingStrategy
implements ISeedingStrategy {
    private DoubleFunction random;

    public RandomSeedingStrategy() {
        this.random = new RandomDoubleFunction(new Random());
    }

    public RandomSeedingStrategy(int n) {
        this.random = new RandomDoubleFunction(new Random(n));
    }

    @Override
    public void seed(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, DoubleMatrix2D doubleMatrix2D3) {
        doubleMatrix2D2.assign(this.random);
        doubleMatrix2D3.assign(this.random);
    }

    public String toString() {
        return "R";
    }

    static class RandomDoubleFunction
    implements DoubleFunction {
        final Random random;

        RandomDoubleFunction(Random random) {
            this.random = random;
        }

        public double apply(double d) {
            return this.random.nextDouble();
        }
    }
}

