/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization.seeding;

import org.carrot2.matrix.factorization.seeding.ISeedingStrategy;
import org.carrot2.matrix.factorization.seeding.ISeedingStrategyFactory;
import org.carrot2.matrix.factorization.seeding.RandomSeedingStrategy;

public class RandomSeedingStrategyFactory
implements ISeedingStrategyFactory {
    private int seed;
    private boolean dateSeed;

    public RandomSeedingStrategyFactory() {
        this.dateSeed = true;
    }

    public RandomSeedingStrategyFactory(int n) {
        this.seed = n;
        this.dateSeed = false;
    }

    @Override
    public ISeedingStrategy createSeedingStrategy() {
        RandomSeedingStrategy randomSeedingStrategy = this.dateSeed ? new RandomSeedingStrategy() : new RandomSeedingStrategy(this.seed);
        return randomSeedingStrategy;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int n) {
        this.seed = n;
        this.dateSeed = false;
    }

    public boolean getDateSeed() {
        return this.dateSeed;
    }

    public void setDateSeed(boolean bl) {
        this.dateSeed = bl;
    }

    public String toString() {
        return "R";
    }
}

