/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.lingo;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import java.util.Arrays;
import java.util.List;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.clustering.lingo.IFeatureScorer;
import org.carrot2.clustering.lingo.ILabelAssigner;
import org.carrot2.clustering.lingo.LingoProcessingContext;
import org.carrot2.clustering.lingo.SimpleLabelAssigner;
import org.carrot2.clustering.lingo.UniqueLabelAssigner;
import org.carrot2.core.attribute.Processing;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.vsm.ITermWeighting;
import org.carrot2.text.vsm.VectorSpaceModelContext;
import org.carrot2.util.GraphUtils;
import org.carrot2.util.LinearApproximation;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.DoubleRange;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.carrot2.util.attribute.constraint.IntRange;

@Bindable(prefix="LingoClusteringAlgorithm")
public class ClusterBuilder {
    @Input
    @Processing
    @Attribute
    @DoubleRange(min=0.0, max=10.0)
    @Group(value="Labels")
    @Level(value=AttributeLevel.MEDIUM)
    @Label(value="Phrase label boost")
    public double phraseLabelBoost = 1.5;
    @Input
    @Processing
    @Attribute
    @IntRange(min=2, max=8)
    @Group(value="Labels")
    @Level(value=AttributeLevel.ADVANCED)
    @Label(value="Phrase length penalty start")
    public int phraseLengthPenaltyStart = 8;
    @Input
    @Processing
    @Attribute
    @IntRange(min=2, max=8)
    @Group(value="Labels")
    @Level(value=AttributeLevel.ADVANCED)
    @Label(value="Phrase length penalty stop")
    public int phraseLengthPenaltyStop = 8;
    @Input
    @Processing
    @Attribute
    @DoubleRange(min=0.0, max=1.0)
    @Group(value="Clusters")
    @Level(value=AttributeLevel.MEDIUM)
    @Label(value="Cluster merging threshold")
    public double clusterMergingThreshold = 0.7;
    public IFeatureScorer featureScorer = null;
    @Input
    @Processing
    @Attribute
    @Required
    @ImplementingClasses(classes={UniqueLabelAssigner.class, SimpleLabelAssigner.class})
    @Group(value="Labels")
    @Level(value=AttributeLevel.ADVANCED)
    @Label(value="Cluster label assignment method")
    public ILabelAssigner labelAssigner = new UniqueLabelAssigner();
    private LinearApproximation documentSizeCoefficients = new LinearApproximation(new double[]{1.0, 1.5, 1.3, 0.9, 0.7, 0.6, 0.3, 0.05, 0.05, 0.05, 0.05}, 0.0, 1.0);

    void buildLabels(LingoProcessingContext lingoProcessingContext, ITermWeighting iTermWeighting) {
        Object object;
        int n;
        IntIntCursor intIntCursor2;
        PreprocessingContext preprocessingContext = lingoProcessingContext.preprocessingContext;
        VectorSpaceModelContext vectorSpaceModelContext = lingoProcessingContext.vsmContext;
        DoubleMatrix2D doubleMatrix2D = lingoProcessingContext.reducedVsmContext.baseMatrix;
        int[] nArray = preprocessingContext.allWords.stemIndex;
        int[] nArray2 = preprocessingContext.allLabels.featureIndex;
        int[] nArray3 = preprocessingContext.allStems.mostFrequentOriginalWordIndex;
        int[][] nArray4 = preprocessingContext.allPhrases.wordIndices;
        BitSet[] bitSetArray = preprocessingContext.allLabels.documentIndices;
        int n2 = preprocessingContext.allWords.image.length;
        int n3 = preprocessingContext.documents.size();
        BitSet bitSet = new BitSet();
        int n4 = 0;
        while (n4 < nArray2.length) {
            int n5 = nArray2[n4];
            if (n5 >= n2) break;
            bitSet.set((long)nArray[n5]);
            ++n4;
        }
        IntIntHashMap intIntHashMap = vectorSpaceModelContext.stemToRowIndex;
        IntIntHashMap intIntHashMap2 = new IntIntHashMap();
        IntArrayList intArrayList = new IntArrayList();
        int n6 = 0;
        for (IntIntCursor intIntCursor2 : intIntHashMap) {
            if (!bitSet.get(intIntCursor2.key)) continue;
            intIntHashMap2.put(n6++, intIntCursor2.key);
            intArrayList.add(intIntCursor2.value);
        }
        intIntCursor2 = this.featureScorer != null ? this.featureScorer.getFeatureScores(lingoProcessingContext) : null;
        Object object2 = new int[n2];
        Arrays.fill((int[])object2, -1);
        int n7 = 0;
        while (n7 < nArray2.length) {
            n = nArray2[n7];
            if (n < n2) {
                object2[n] = n7;
            }
            ++n7;
        }
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.viewSelection(intArrayList.toArray(), null).copy();
        n = 0;
        while (n < doubleMatrix2D2.rows()) {
            object = object2[nArray3[intIntHashMap2.get(n)]];
            double d = this.getDocumentCountPenalty((int)object, n3, bitSetArray);
            if (intIntCursor2 != null) {
                d *= intIntCursor2[object];
            }
            doubleMatrix2D2.viewRow(n).assign(Functions.mult((double)d));
            ++n;
        }
        DoubleMatrix2D doubleMatrix2D3 = vectorSpaceModelContext.termPhraseMatrix;
        object = preprocessingContext.allLabels.firstPhraseIndex;
        DoubleMatrix2D doubleMatrix2D4 = null;
        if (doubleMatrix2D3 != null) {
            doubleMatrix2D4 = doubleMatrix2D3.zMult(doubleMatrix2D, null, 1.0, 0.0, false, false);
            if (this.phraseLengthPenaltyStop < this.phraseLengthPenaltyStart) {
                this.phraseLengthPenaltyStop = this.phraseLengthPenaltyStart;
            }
            double d = 1.0 / (double)(this.phraseLengthPenaltyStop - this.phraseLengthPenaltyStart + 1);
            int n8 = 0;
            while (n8 < doubleMatrix2D4.rows()) {
                double d2;
                int n9 = nArray2[n8 + object];
                int[] nArray5 = nArray4[n9 - n2];
                if (nArray5.length >= this.phraseLengthPenaltyStop) {
                    d2 = 0.0;
                } else {
                    d2 = this.getDocumentCountPenalty(n8 + object, n3, bitSetArray);
                    if (nArray5.length >= this.phraseLengthPenaltyStart) {
                        d2 *= 1.0 - d * (double)(nArray5.length - this.phraseLengthPenaltyStart + 1);
                    }
                    if (intIntCursor2 != null) {
                        d2 *= intIntCursor2[n8 + object];
                    }
                }
                doubleMatrix2D4.viewRow(n8).assign(Functions.mult((double)(d2 * this.phraseLabelBoost)));
                ++n8;
            }
        }
        this.labelAssigner.assignLabels(lingoProcessingContext, doubleMatrix2D2, intIntHashMap2, doubleMatrix2D4);
    }

    private double getDocumentCountPenalty(int n, int n2, BitSet[] bitSetArray) {
        return this.documentSizeCoefficients.getValue((double)bitSetArray[n].cardinality() / (double)n2);
    }

    void assignDocuments(LingoProcessingContext lingoProcessingContext) {
        int[] nArray = lingoProcessingContext.clusterLabelFeatureIndex;
        BitSet[] bitSetArray = new BitSet[nArray.length];
        int[] nArray2 = lingoProcessingContext.preprocessingContext.allLabels.featureIndex;
        BitSet[] bitSetArray2 = lingoProcessingContext.preprocessingContext.allLabels.documentIndices;
        IntIntHashMap intIntHashMap = new IntIntHashMap();
        int n = 0;
        while (n < nArray2.length) {
            intIntHashMap.put(nArray2[n], n);
            ++n;
        }
        n = 0;
        while (n < bitSetArray.length) {
            bitSetArray[n] = bitSetArray2[intIntHashMap.get(nArray[n])];
            ++n;
        }
        lingoProcessingContext.clusterDocuments = bitSetArray;
    }

    void merge(LingoProcessingContext lingoProcessingContext) {
        final BitSet[] bitSetArray = lingoProcessingContext.clusterDocuments;
        int[] nArray = lingoProcessingContext.clusterLabelFeatureIndex;
        double[] dArray = lingoProcessingContext.clusterLabelScore;
        List list = GraphUtils.findCoherentSubgraphs((int)bitSetArray.length, (GraphUtils.IArcPredicate)new GraphUtils.IArcPredicate(){
            private BitSet temp = new BitSet();

            public boolean isArcPresent(int n, int n2) {
                int n3;
                this.temp.clear();
                BitSet bitSet = bitSetArray[n];
                BitSet bitSet2 = bitSetArray[n2];
                if (bitSet.cardinality() < bitSet2.cardinality()) {
                    this.temp.or(bitSet);
                    this.temp.intersect(bitSet2);
                    n3 = (int)bitSet2.cardinality();
                } else {
                    this.temp.or(bitSet2);
                    this.temp.intersect(bitSet);
                    n3 = (int)bitSet.cardinality();
                }
                return (double)this.temp.cardinality() / (double)n3 >= ClusterBuilder.this.clusterMergingThreshold;
            }
        }, (boolean)true);
        for (IntArrayList intArrayList : list) {
            int n;
            int n2 = -1;
            double d = -1.0;
            int[] nArray2 = intArrayList.buffer;
            int n3 = intArrayList.size();
            int n4 = 0;
            while (n4 < n3) {
                n = nArray2[n4];
                if (dArray[n] > d) {
                    n2 = n;
                    d = dArray[n];
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < n3) {
                n = nArray2[n4];
                if (n != n2) {
                    bitSetArray[n2].or(bitSetArray[n]);
                    nArray[n] = -1;
                    bitSetArray[n] = null;
                }
                ++n4;
            }
        }
    }
}

