/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.lingo;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.clustering.lingo.ILabelAssigner;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class ClusterBuilderDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.clustering.lingo.ClusterBuilder";
    public final String prefix = "LingoClusteringAlgorithm";
    public final String title = "Builds cluster labels based on the reduced term-document matrix and assigns documents to the labels";
    public final String label = "";
    public final String description = "";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(ClusterBuilderDescriptor.attributes.clusterMergingThreshold);
        hashSet.add(ClusterBuilderDescriptor.attributes.labelAssigner);
        hashSet.add(ClusterBuilderDescriptor.attributes.phraseLabelBoost);
        hashSet.add(ClusterBuilderDescriptor.attributes.phraseLengthPenaltyStart);
        hashSet.add(ClusterBuilderDescriptor.attributes.phraseLengthPenaltyStop);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(ClusterBuilderDescriptor.attributes.clusterMergingThreshold);
        hashSet2.add(ClusterBuilderDescriptor.attributes.labelAssigner);
        hashSet2.add(ClusterBuilderDescriptor.attributes.phraseLabelBoost);
        hashSet2.add(ClusterBuilderDescriptor.attributes.phraseLengthPenaltyStart);
        hashSet2.add(ClusterBuilderDescriptor.attributes.phraseLengthPenaltyStop);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "LingoClusteringAlgorithm";
    }

    public String getTitle() {
        return "Builds cluster labels based on the reduced term-document matrix and assigns documents to the labels";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder clusterMergingThreshold(double d) {
            this.map.put("LingoClusteringAlgorithm.clusterMergingThreshold", d);
            return this;
        }

        public AttributeBuilder clusterMergingThreshold(IObjectFactory<? extends Double> iObjectFactory) {
            this.map.put("LingoClusteringAlgorithm.clusterMergingThreshold", iObjectFactory);
            return this;
        }

        public AttributeBuilder labelAssigner(ILabelAssigner iLabelAssigner) {
            this.map.put("LingoClusteringAlgorithm.labelAssigner", iLabelAssigner);
            return this;
        }

        public AttributeBuilder labelAssigner(Class<?> clazz) {
            this.map.put("LingoClusteringAlgorithm.labelAssigner", clazz);
            return this;
        }

        public AttributeBuilder labelAssigner(IObjectFactory<? extends ILabelAssigner> iObjectFactory) {
            this.map.put("LingoClusteringAlgorithm.labelAssigner", iObjectFactory);
            return this;
        }

        public AttributeBuilder phraseLabelBoost(double d) {
            this.map.put("LingoClusteringAlgorithm.phraseLabelBoost", d);
            return this;
        }

        public AttributeBuilder phraseLabelBoost(IObjectFactory<? extends Double> iObjectFactory) {
            this.map.put("LingoClusteringAlgorithm.phraseLabelBoost", iObjectFactory);
            return this;
        }

        public AttributeBuilder phraseLengthPenaltyStart(int n) {
            this.map.put("LingoClusteringAlgorithm.phraseLengthPenaltyStart", n);
            return this;
        }

        public AttributeBuilder phraseLengthPenaltyStart(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("LingoClusteringAlgorithm.phraseLengthPenaltyStart", iObjectFactory);
            return this;
        }

        public AttributeBuilder phraseLengthPenaltyStop(int n) {
            this.map.put("LingoClusteringAlgorithm.phraseLengthPenaltyStop", n);
            return this;
        }

        public AttributeBuilder phraseLengthPenaltyStop(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("LingoClusteringAlgorithm.phraseLengthPenaltyStop", iObjectFactory);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo clusterMergingThreshold = new AttributeInfo("LingoClusteringAlgorithm.clusterMergingThreshold", "org.carrot2.clustering.lingo.ClusterBuilder", "clusterMergingThreshold", "Cluster merging threshold. The percentage overlap between two cluster's documents\nrequired for the clusters to be merged into one clusters. Low values will result in\nmore aggressive merging, which may lead to irrelevant documents in clusters. High\nvalues will result in fewer clusters being merged, which may lead to very similar\nor duplicated clusters.", "Cluster merging threshold", "Cluster merging threshold", "The percentage overlap between two cluster's documents required for the clusters to be merged into one clusters. Low values will result in more aggressive merging, which may lead to irrelevant documents in clusters. High values will result in fewer clusters being merged, which may lead to very similar or duplicated clusters.", "Clusters", AttributeLevel.MEDIUM, null);
        public final AttributeInfo labelAssigner = new AttributeInfo("LingoClusteringAlgorithm.labelAssigner", "org.carrot2.clustering.lingo.ClusterBuilder", "labelAssigner", "Cluster label assignment method.", "Cluster label assignment method", "Cluster label assignment method", null, "Labels", AttributeLevel.ADVANCED, null);
        public final AttributeInfo phraseLabelBoost = new AttributeInfo("LingoClusteringAlgorithm.phraseLabelBoost", "org.carrot2.clustering.lingo.ClusterBuilder", "phraseLabelBoost", "Phrase label boost. The weight of multi-word labels relative to one-word labels.\nLow values will result in more one-word labels being produced, higher values will\nfavor multi-word labels.", "Phrase label boost", "Phrase label boost", "The weight of multi-word labels relative to one-word labels. Low values will result in more one-word labels being produced, higher values will favor multi-word labels.", "Labels", AttributeLevel.MEDIUM, null);
        public final AttributeInfo phraseLengthPenaltyStart = new AttributeInfo("LingoClusteringAlgorithm.phraseLengthPenaltyStart", "org.carrot2.clustering.lingo.ClusterBuilder", "phraseLengthPenaltyStart", "Phrase length penalty start. The phrase length at which the overlong multi-word\nlabels should start to be penalized. Phrases of length smaller than\n<code>phraseLengthPenaltyStart</code> will not be penalized.", "Phrase length penalty start", "Phrase length penalty start", "The phrase length at which the overlong multi-word labels should start to be penalized. Phrases of length smaller than <code>phraseLengthPenaltyStart</code> will not be penalized.", "Labels", AttributeLevel.ADVANCED, null);
        public final AttributeInfo phraseLengthPenaltyStop = new AttributeInfo("LingoClusteringAlgorithm.phraseLengthPenaltyStop", "org.carrot2.clustering.lingo.ClusterBuilder", "phraseLengthPenaltyStop", "Phrase length penalty stop. The phrase length at which the overlong multi-word\nlabels should be removed completely. Phrases of length larger than\n<code>phraseLengthPenaltyStop</code> will be removed.", "Phrase length penalty stop", "Phrase length penalty stop", "The phrase length at which the overlong multi-word labels should be removed completely. Phrases of length larger than <code>phraseLengthPenaltyStop</code> will be removed.", "Labels", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys {
        public static final String CLUSTER_MERGING_THRESHOLD = "LingoClusteringAlgorithm.clusterMergingThreshold";
        public static final String LABEL_ASSIGNER = "LingoClusteringAlgorithm.labelAssigner";
        public static final String PHRASE_LABEL_BOOST = "LingoClusteringAlgorithm.phraseLabelBoost";
        public static final String PHRASE_LENGTH_PENALTY_START = "LingoClusteringAlgorithm.phraseLengthPenaltyStart";
        public static final String PHRASE_LENGTH_PENALTY_STOP = "LingoClusteringAlgorithm.phraseLengthPenaltyStop";

        protected Keys() {
        }
    }
}

