/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.lingo;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.clustering.lingo.ClusterBuilderDescriptor;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.CommonAttributesDescriptor;
import org.carrot2.text.clustering.MultilingualClusteringDescriptor;
import org.carrot2.text.preprocessing.LabelFormatterDescriptor;
import org.carrot2.text.preprocessing.pipeline.IPreprocessingPipeline;
import org.carrot2.text.vsm.TermDocumentMatrixBuilderDescriptor;
import org.carrot2.text.vsm.TermDocumentMatrixReducerDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class LingoClusteringAlgorithmDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.clustering.lingo.LingoClusteringAlgorithm";
    public final String prefix = "LingoClusteringAlgorithm";
    public final String title = "Lingo clustering algorithm";
    public final String label = "Lingo Clustering";
    public final String description = "Implementation as described in: <i> \"Stanis\u0139\u201aaw Osi\u0139\u201eski, Dawid Weiss: A Concept-Driven Algorithm for Clustering Search Results. IEEE Intelligent Systems, May/June, 3 (vol. 20), 2005, pp. 48\u00e2\u20ac\u201d54.\"</i>.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(LingoClusteringAlgorithmDescriptor.attributes.clusters);
        hashSet.add(LingoClusteringAlgorithmDescriptor.attributes.desiredClusterCountBase);
        hashSet.add(LingoClusteringAlgorithmDescriptor.attributes.documents);
        hashSet.add(LingoClusteringAlgorithmDescriptor.attributes.preprocessingPipeline);
        hashSet.add(LingoClusteringAlgorithmDescriptor.attributes.query);
        hashSet.add(LingoClusteringAlgorithmDescriptor.attributes.scoreWeight);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(LingoClusteringAlgorithmDescriptor.attributes.clusters);
        hashSet2.add(LingoClusteringAlgorithmDescriptor.attributes.desiredClusterCountBase);
        hashSet2.add(LingoClusteringAlgorithmDescriptor.attributes.documents);
        hashSet2.add(LingoClusteringAlgorithmDescriptor.attributes.preprocessingPipeline);
        hashSet2.add(LingoClusteringAlgorithmDescriptor.attributes.query);
        hashSet2.add(LingoClusteringAlgorithmDescriptor.attributes.scoreWeight);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "LingoClusteringAlgorithm";
    }

    public String getTitle() {
        return "Lingo clustering algorithm";
    }

    public String getLabel() {
        return "Lingo Clustering";
    }

    public String getDescription() {
        return "Implementation as described in: <i> \"Stanis\u0139\u201aaw Osi\u0139\u201eski, Dawid Weiss: A Concept-Driven Algorithm for Clustering Search Results. IEEE Intelligent Systems, May/June, 3 (vol. 20), 2005, pp. 48\u00e2\u20ac\u201d54.\"</i>.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public List<Cluster> clusters() {
            return (List)this.map.get("clusters");
        }

        public AttributeBuilder desiredClusterCountBase(int n) {
            this.map.put("LingoClusteringAlgorithm.desiredClusterCountBase", n);
            return this;
        }

        public AttributeBuilder desiredClusterCountBase(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("LingoClusteringAlgorithm.desiredClusterCountBase", iObjectFactory);
            return this;
        }

        public AttributeBuilder documents(List<Document> list) {
            this.map.put("documents", list);
            return this;
        }

        public AttributeBuilder documents(IObjectFactory<? extends List<Document>> iObjectFactory) {
            this.map.put("documents", iObjectFactory);
            return this;
        }

        public AttributeBuilder preprocessingPipeline(IPreprocessingPipeline iPreprocessingPipeline) {
            this.map.put("LingoClusteringAlgorithm.preprocessingPipeline", iPreprocessingPipeline);
            return this;
        }

        public AttributeBuilder preprocessingPipeline(Class<?> clazz) {
            this.map.put("LingoClusteringAlgorithm.preprocessingPipeline", clazz);
            return this;
        }

        public AttributeBuilder preprocessingPipeline(IObjectFactory<? extends IPreprocessingPipeline> iObjectFactory) {
            this.map.put("LingoClusteringAlgorithm.preprocessingPipeline", iObjectFactory);
            return this;
        }

        public AttributeBuilder query(String string) {
            this.map.put("query", string);
            return this;
        }

        public AttributeBuilder query(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("query", iObjectFactory);
            return this;
        }

        public AttributeBuilder scoreWeight(double d) {
            this.map.put("LingoClusteringAlgorithm.scoreWeight", d);
            return this;
        }

        public AttributeBuilder scoreWeight(IObjectFactory<? extends Double> iObjectFactory) {
            this.map.put("LingoClusteringAlgorithm.scoreWeight", iObjectFactory);
            return this;
        }

        public ClusterBuilderDescriptor.AttributeBuilder clusterBuilder() {
            return ClusterBuilderDescriptor.attributeBuilder(this.map);
        }

        public LabelFormatterDescriptor.AttributeBuilder labelFormatter() {
            return LabelFormatterDescriptor.attributeBuilder(this.map);
        }

        public TermDocumentMatrixBuilderDescriptor.AttributeBuilder matrixBuilder() {
            return TermDocumentMatrixBuilderDescriptor.attributeBuilder(this.map);
        }

        public TermDocumentMatrixReducerDescriptor.AttributeBuilder matrixReducer() {
            return TermDocumentMatrixReducerDescriptor.attributeBuilder(this.map);
        }

        public MultilingualClusteringDescriptor.AttributeBuilder multilingualClustering() {
            return MultilingualClusteringDescriptor.attributeBuilder(this.map);
        }
    }

    public static final class Attributes {
        public final AttributeInfo clusters;
        public final AttributeInfo desiredClusterCountBase;
        public final AttributeInfo documents;
        public final AttributeInfo preprocessingPipeline;
        public final AttributeInfo query;
        public final AttributeInfo scoreWeight;
        public final ClusterBuilderDescriptor.Attributes clusterBuilder;
        public final LabelFormatterDescriptor.Attributes labelFormatter;
        public final TermDocumentMatrixBuilderDescriptor.Attributes matrixBuilder;
        public final TermDocumentMatrixReducerDescriptor.Attributes matrixReducer;
        public final MultilingualClusteringDescriptor.Attributes multilingualClustering;

        private Attributes() {
            this.clusters = new AttributeInfo("clusters", "org.carrot2.clustering.lingo.LingoClusteringAlgorithm", "clusters", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.clusters);
            this.desiredClusterCountBase = new AttributeInfo("LingoClusteringAlgorithm.desiredClusterCountBase", "org.carrot2.clustering.lingo.LingoClusteringAlgorithm", "desiredClusterCountBase", "Desired cluster count base. Base factor used to calculate the number of clusters\nbased on the number of documents on input. The larger the value, the more clusters\nwill be created. The number of clusters created by the algorithm will be\nproportional to the cluster count base, but not in a linear way.", "Cluster count base", "Desired cluster count base", "Base factor used to calculate the number of clusters based on the number of documents on input. The larger the value, the more clusters will be created. The number of clusters created by the algorithm will be proportional to the cluster count base, but not in a linear way.", "Clusters", AttributeLevel.BASIC, null);
            this.documents = new AttributeInfo("documents", "org.carrot2.clustering.lingo.LingoClusteringAlgorithm", "documents", "Documents to cluster.", null, "Documents to cluster", null, null, null, CommonAttributesDescriptor.attributes.documents);
            this.preprocessingPipeline = new AttributeInfo("LingoClusteringAlgorithm.preprocessingPipeline", "org.carrot2.clustering.lingo.LingoClusteringAlgorithm", "preprocessingPipeline", "Common preprocessing tasks handler, contains bindable attributes.", null, "Common preprocessing tasks handler, contains bindable attributes", null, null, AttributeLevel.ADVANCED, null);
            this.query = new AttributeInfo("query", "org.carrot2.clustering.lingo.LingoClusteringAlgorithm", "query", "Query that produced the documents. The query will help the algorithm to create\nbetter clusters. Therefore, providing the query is optional but desirable.", null, "Query that produced the documents", "The query will help the algorithm to create better clusters. Therefore, providing the query is optional but desirable.", null, null, CommonAttributesDescriptor.attributes.query);
            this.scoreWeight = new AttributeInfo("LingoClusteringAlgorithm.scoreWeight", "org.carrot2.clustering.lingo.LingoClusteringAlgorithm", "scoreWeight", "Balance between cluster score and size during cluster sorting. Value equal to 0.0\nwill cause Lingo to sort clusters based only on cluster size. Value equal to 1.0\nwill cause Lingo to sort clusters based only on cluster score.", "Size-Score sorting ratio", "Balance between cluster score and size during cluster sorting", "Value equal to 0.0 will cause Lingo to sort clusters based only on cluster size. Value equal to 1.0 will cause Lingo to sort clusters based only on cluster score.", "Clusters", AttributeLevel.MEDIUM, null);
            this.clusterBuilder = ClusterBuilderDescriptor.attributes;
            this.labelFormatter = LabelFormatterDescriptor.attributes;
            this.matrixBuilder = TermDocumentMatrixBuilderDescriptor.attributes;
            this.matrixReducer = TermDocumentMatrixReducerDescriptor.attributes;
            this.multilingualClustering = MultilingualClusteringDescriptor.attributes;
        }
    }

    public static class Keys {
        public static final String CLUSTERS = "clusters";
        public static final String DESIRED_CLUSTER_COUNT_BASE = "LingoClusteringAlgorithm.desiredClusterCountBase";
        public static final String DOCUMENTS = "documents";
        public static final String PREPROCESSING_PIPELINE = "LingoClusteringAlgorithm.preprocessingPipeline";
        public static final String QUERY = "query";
        public static final String SCORE_WEIGHT = "LingoClusteringAlgorithm.scoreWeight";

        protected Keys() {
        }
    }
}

