/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

public class CharArrayUtils {
    public static final char[] EMPTY_ARRAY = new char[0];

    public static char[] toLowerCaseInPlace(char[] cArray) {
        int n = cArray.length;
        while (--n >= 0) {
            cArray[n] = Character.toLowerCase(cArray[n]);
        }
        return cArray;
    }

    public static char[] toLowerCaseCopy(char[] cArray) {
        return CharArrayUtils.toLowerCaseInPlace((char[])cArray.clone());
    }

    public static float getCapitalizedRatio(char[] cArray) {
        int n = cArray.length;
        if (n == 0) {
            return 0.0f;
        }
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            if (!Character.isUpperCase(cArray[n3])) continue;
            ++n2;
        }
        return (float)n2 / (float)n;
    }

    public static boolean hasCapitalizedLetters(char[] cArray) {
        int n = cArray.length;
        while (--n >= 0) {
            if (!Character.isUpperCase(cArray[n])) continue;
            return true;
        }
        return false;
    }

    public static char[] toCapitalizedCopy(char[] cArray) {
        int n = cArray.length;
        if (n == 0) {
            return cArray;
        }
        char[] cArray2 = CharArrayUtils.toLowerCaseCopy(cArray);
        cArray2[0] = Character.toUpperCase(cArray2[0]);
        return cArray2;
    }

    public static boolean toLowerCase(char[] cArray, char[] cArray2) {
        return CharArrayUtils.toLowerCase(cArray, cArray2, 0, cArray.length);
    }

    public static boolean toLowerCase(char[] cArray, char[] cArray2, int n, int n2) {
        assert (cArray2.length >= n2) : "Buffer too small.";
        assert (n + n2 <= cArray.length) : "Word too short.";
        assert (n >= 0) : "Start must be >= 0";
        boolean bl = false;
        int n3 = n2;
        while (--n3 >= 0) {
            char c;
            char c2 = cArray[n3 + n];
            cArray2[n3] = c = Character.toLowerCase(c2);
            bl |= c2 != c;
        }
        return bl;
    }
}

