/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public final class CloseableUtils {
    private CloseableUtils() {
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void close(Closeable ... closeableArray) {
        Closeable[] closeableArray2 = closeableArray;
        int n = closeableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Closeable closeable = closeableArray2[n2];
            CloseableUtils.close(closeable);
            ++n2;
        }
    }

    public static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public static void close(Connection ... connectionArray) {
        Connection[] connectionArray2 = connectionArray;
        int n = connectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Connection connection = connectionArray2[n2];
            CloseableUtils.close(connection);
            ++n2;
        }
    }

    public static void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public static void close(Statement ... statementArray) {
        Statement[] statementArray2 = statementArray;
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray2[n2];
            CloseableUtils.close(statement);
            ++n2;
        }
    }

    public static void close(Socket ... socketArray) {
        Socket[] socketArray2 = socketArray;
        int n = socketArray.length;
        int n2 = 0;
        while (n2 < n) {
            Socket socket = socketArray2[n2];
            try {
                if (socket != null && !socket.isClosed()) {
                    socket.close();
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
    }
}

