/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ForwardingExecutorService;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorServiceUtils {
    public static ExecutorService createExecutorService(int n, Class<?> clazz) {
        String string = clazz.getSimpleName();
        ClassLoader classLoader = clazz.getClassLoader();
        AccountingThreadFactory accountingThreadFactory = new AccountingThreadFactory(classLoader, string);
        return new AccountingExecutorService(n, accountingThreadFactory);
    }

    static final class AccountingExecutorService
    extends ForwardingExecutorService {
        private ExecutorService delegate;
        private AccountingThreadFactory threadFactory;

        public AccountingExecutorService(int n, AccountingThreadFactory accountingThreadFactory) {
            this.delegate = Executors.newFixedThreadPool(n, accountingThreadFactory);
            this.threadFactory = accountingThreadFactory;
        }

        public void shutdown() {
            super.shutdown();
            this.threadFactory.join();
        }

        public List<Runnable> shutdownNow() {
            List list = super.shutdownNow();
            this.threadFactory.join();
            return list;
        }

        protected ExecutorService delegate() {
            return this.delegate;
        }
    }

    static final class AccountingThreadFactory
    implements ThreadFactory {
        private final ClassLoader classLoader;
        private final String baseName;
        private final AtomicInteger counter = new AtomicInteger();
        private final List<WeakReference<Thread>> threads = Collections.synchronizedList(Lists.newArrayList());

        public AccountingThreadFactory(ClassLoader classLoader, String string) {
            this.classLoader = classLoader;
            this.baseName = string;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "SharedExecutor-" + this.baseName + "-" + this.counter.getAndIncrement());
            thread.setDaemon(true);
            thread.setContextClassLoader(this.classLoader);
            this.threads.add(new WeakReference<Thread>(thread));
            return thread;
        }

        void join() {
            for (WeakReference<Thread> weakReference : this.threads) {
                Thread thread = (Thread)weakReference.get();
                if (thread == null) continue;
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }
}

