/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

public class LinearApproximation {
    private double[] points;
    private double argMin;
    private double argMax;
    private double step;
    private double[] arguments;

    public LinearApproximation(double[] dArray, double d, double d2) {
        this.points = dArray;
        this.argMin = d;
        this.argMax = d2;
        this.arguments = new double[dArray.length];
        this.step = (d2 - d) / (double)(dArray.length - 1);
        int n = 0;
        while (n < this.arguments.length) {
            this.arguments[n] = d + this.step * (double)n;
            ++n;
        }
    }

    public double getValue(double d) {
        if (this.points.length == 1) {
            return this.points[0];
        }
        if (d <= this.arguments[0]) {
            return this.points[0];
        }
        if (d >= this.arguments[this.arguments.length - 1]) {
            return this.points[this.points.length - 1];
        }
        int n = (int)((double)(this.points.length - 1) * (d - this.argMin) / (this.argMax - this.argMin));
        return this.points[n] + (d - this.arguments[n]) / this.step * (this.points[n + 1] - this.points[n]);
    }
}

