/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

public abstract class PriorityQueue<T> {
    private int size;
    private int maxSize;
    protected T[] heap;

    protected abstract boolean lessThan(T var1, T var2);

    protected T getSentinelObject() {
        return null;
    }

    protected final void initialize(int n) {
        this.size = 0;
        int n2 = n == 0 ? 2 : (n == Integer.MAX_VALUE ? Integer.MAX_VALUE : n + 1);
        this.heap = new Object[n2];
        this.maxSize = n;
        T t = this.getSentinelObject();
        if (t != null) {
            this.heap[1] = t;
            int n3 = 2;
            while (n3 < this.heap.length) {
                this.heap[n3] = this.getSentinelObject();
                ++n3;
            }
            this.size = n;
        }
    }

    public final T add(T t) {
        ++this.size;
        this.heap[this.size] = t;
        this.upHeap();
        return this.heap[1];
    }

    public T insertWithOverflow(T t) {
        if (this.size < this.maxSize) {
            this.add(t);
            return null;
        }
        if (this.size > 0 && !this.lessThan(t, this.heap[1])) {
            T t2 = this.heap[1];
            this.heap[1] = t;
            this.updateTop();
            return t2;
        }
        return t;
    }

    public final T top() {
        return this.heap[1];
    }

    public final T pop() {
        if (this.size > 0) {
            T t = this.heap[1];
            this.heap[1] = this.heap[this.size];
            this.heap[this.size] = null;
            --this.size;
            this.downHeap();
            return t;
        }
        return null;
    }

    public final T updateTop() {
        this.downHeap();
        return this.heap[1];
    }

    public final int size() {
        return this.size;
    }

    public final void clear() {
        int n = 0;
        while (n <= this.size) {
            this.heap[n] = null;
            ++n;
        }
        this.size = 0;
    }

    private final void upHeap() {
        int n = this.size;
        T t = this.heap[n];
        int n2 = n >>> 1;
        while (n2 > 0 && this.lessThan(t, this.heap[n2])) {
            this.heap[n] = this.heap[n2];
            n = n2;
            n2 >>>= 1;
        }
        this.heap[n] = t;
    }

    private final void downHeap() {
        int n = 1;
        T t = this.heap[n];
        int n2 = n << 1;
        int n3 = n2 + 1;
        if (n3 <= this.size && this.lessThan(this.heap[n3], this.heap[n2])) {
            n2 = n3;
        }
        while (n2 <= this.size && this.lessThan(this.heap[n2], t)) {
            this.heap[n] = this.heap[n2];
            n = n2;
            n3 = (n2 = n << 1) + 1;
            if (n3 > this.size || !this.lessThan(this.heap[n3], this.heap[n2])) continue;
            n2 = n3;
        }
        this.heap[n] = t;
    }
}

