/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.util.LinkedList;

public class RollingWindowAverage {
    public static final int MILLIS = 1;
    public static final int SECOND = 1000;
    public static final int MINUTE = 60000;
    final LinkedList<Bucket> buckets = new LinkedList();
    private long currentSum;
    private long currentCount;
    private long bucketSizeMillis;
    private long windowSizeMillis;

    public RollingWindowAverage(long l, long l2) {
        if (l2 <= 0L || l <= 0L || l <= l2) {
            throw new IllegalArgumentException("Bucket size must be smaller than window size.");
        }
        this.bucketSizeMillis = l2;
        this.windowSizeMillis = l;
    }

    public final void add(long l, long l2) {
        Bucket bucket;
        block3: {
            long l3;
            block2: {
                l3 = this.getNow();
                this.removeOldBuckets(l3);
                if (this.buckets.isEmpty()) break block2;
                bucket = this.buckets.getFirst();
                if (bucket.deadline >= l) break block3;
            }
            bucket = new Bucket(l3 + this.bucketSizeMillis);
            this.buckets.addFirst(bucket);
        }
        ++bucket.elements;
        ++this.currentCount;
        bucket.sum += l2;
        this.currentSum += l2;
    }

    public final double getCurrentAverage() {
        this.removeOldBuckets(this.getNow());
        if (this.currentCount == 0L) {
            return 0.0;
        }
        return (double)this.currentSum / (double)this.currentCount;
    }

    public final long getUpdatesInWindow() {
        this.removeOldBuckets(this.getNow());
        return this.currentCount;
    }

    public final long getWindowSizeMillis() {
        return this.windowSizeMillis;
    }

    long getNow() {
        return System.currentTimeMillis();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private void removeOldBuckets(long l) {
        Bucket bucket;
        long l2 = l - this.windowSizeMillis;
        if (true) {
            return;
        }
        do {
            this.currentSum -= bucket.sum;
            this.currentCount -= bucket.elements;
            this.buckets.removeLast();
            if (this.buckets.isEmpty()) return;
            bucket = this.buckets.getLast();
        } while (bucket.deadline < l2);
    }

    private static final class Bucket {
        public final long deadline;
        public long elements;
        public long sum;

        public Bucket(long l) {
            this.deadline = l;
        }
    }
}

