/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.carrot2.util.CloseableUtils;

public final class StreamUtils {
    public static final Writer NULL_WRITER = new NullWriter();

    private StreamUtils() {
    }

    public static byte[] readFullyAndClose(InputStream inputStream) throws IOException {
        try {
            byte[] byArray = StreamUtils.readFully(inputStream);
            return byArray;
        }
        finally {
            CloseableUtils.close((Closeable)inputStream);
        }
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static char[] readFullyAndClose(Reader reader) throws IOException {
        try {
            char[] cArray = StreamUtils.readFully(reader);
            return cArray;
        }
        finally {
            CloseableUtils.close((Closeable)reader);
        }
    }

    public static char[] readFully(Reader reader) throws IOException {
        int n;
        CharArrayWriter charArrayWriter = new CharArrayWriter(8192);
        char[] cArray = new char[8192];
        while ((n = reader.read(cArray)) > 0) {
            charArrayWriter.write(cArray, 0, n);
        }
        return charArrayWriter.toCharArray();
    }

    public static InputStream prefetch(InputStream inputStream) throws IOException {
        if (inputStream instanceof ByteArrayInputStream) {
            return inputStream;
        }
        return new ByteArrayInputStream(StreamUtils.readFullyAndClose(inputStream));
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        while ((n2 = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static void copyAndClose(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        try {
            StreamUtils.copy(inputStream, outputStream, n);
        }
        catch (Throwable throwable) {
            CloseableUtils.close(inputStream, outputStream);
            throw throwable;
        }
        CloseableUtils.close(inputStream, outputStream);
    }

    static class NullWriter
    extends Writer {
        NullWriter() {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
        }
    }
}

