/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;
import org.carrot2.util.ExceptionUtils;

public final class StringUtils {
    private static final Pattern CAMEL_CASE_FRAGMENT = Pattern.compile("([A-Z]{1,}(?=[0-9]+))|([A-Z]{1,}(?=[A-Z][a-z0-9]+))|([A-Z]?[A-Z]+[a-z0-9]+)|([0-9]+)");
    private static final Pattern HTML_TAG_PATTERN = Pattern.compile("<.+?>", 2);

    private StringUtils() {
    }

    public static <T> String toString(Iterable<T> iterable, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            stringBuilder.append(t);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String splitCamelCase(String string) {
        return CAMEL_CASE_FRAGMENT.matcher(string).replaceAll("$0 ").trim();
    }

    public static String urlEncodeWrapException(String string, String string2) {
        try {
            return URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ExceptionUtils.wrapAsRuntimeException(unsupportedEncodingException);
        }
    }

    public static String removeHtmlTags(String string) {
        return HTML_TAG_PATTERN.matcher(string).replaceAll("");
    }

    public static String identifierToHumanReadable(String string) {
        return WordUtils.capitalizeFully((String)string.replace('_', ' '));
    }

    public static String join(String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(object.toString());
            }
            ++n2;
        }
        return stringBuilder.toString();
    }
}

