/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.carrot2.util.simplexml.SimpleXmlWrapperValue;
import org.carrot2.util.simplexml.SimpleXmlWrappers;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persist;

@Root(name="value-set")
public class AttributeValueSet {
    @Element
    public String label;
    @Element(required=false)
    public String description;
    Map<String, Object> overridenAttributeValues;
    AttributeValueSet baseAttributeValueSet;
    @Attribute(name="based-on", required=false)
    String baseAttributeValueSetId;
    @ElementMap(entry="attribute", key="key", attribute=true, inline=true, required=false)
    private TreeMap<String, SimpleXmlWrapperValue> overridenAttributeValuesForSerialization;

    AttributeValueSet() {
    }

    public AttributeValueSet(String string) {
        this(string, null);
    }

    public AttributeValueSet(String string, AttributeValueSet attributeValueSet) {
        this(string, null, attributeValueSet);
    }

    public AttributeValueSet(String string, String string2, AttributeValueSet attributeValueSet) {
        this.label = string;
        this.description = string2;
        this.baseAttributeValueSet = attributeValueSet;
        this.overridenAttributeValues = Maps.newHashMap();
    }

    public Object getAttributeValue(String string) {
        if (this.overridenAttributeValues.containsKey(string)) {
            return this.overridenAttributeValues.get(string);
        }
        if (this.baseAttributeValueSet != null) {
            return this.baseAttributeValueSet.getAttributeValue(string);
        }
        return null;
    }

    public Map<String, Object> getAttributeValues() {
        HashMap hashMap = Maps.newHashMap();
        if (this.baseAttributeValueSet != null) {
            hashMap.putAll(this.baseAttributeValueSet.getAttributeValues());
        }
        hashMap.putAll(this.overridenAttributeValues);
        return hashMap;
    }

    public Object setAttributeValue(String string, Object object) {
        return this.overridenAttributeValues.put(string, object);
    }

    public void setAttributeValues(Map<String, Object> map) {
        this.overridenAttributeValues.putAll(map);
    }

    public static Map<String, Object> getAttributeValues(AttributeValueSet attributeValueSet) {
        return attributeValueSet != null ? attributeValueSet.getAttributeValues() : null;
    }

    @Persist
    private void convertAttributeValuesToStrings() {
        this.overridenAttributeValuesForSerialization = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.overridenAttributeValuesForSerialization.putAll(SimpleXmlWrappers.wrap(this.overridenAttributeValues));
    }

    @Commit
    private void convertAttributeValuesFromStrings() throws Exception {
        this.overridenAttributeValues = this.overridenAttributeValuesForSerialization == null ? Maps.newHashMap() : SimpleXmlWrappers.unwrap(this.overridenAttributeValuesForSerialization);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AttributeValueSet [");
        boolean bl = true;
        for (Map.Entry<String, Object> entry : this.getAttributeValues().entrySet()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey() != null ? entry.getKey() : "null");
            stringBuilder.append('=');
            stringBuilder.append(entry.getValue() != null ? entry.getValue().toString() : "null");
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

