/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.carrot2.util.attribute.AttributeValueSet;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persist;
import org.simpleframework.xml.core.Persister;

@Root(name="attribute-sets")
public class AttributeValueSets {
    @ElementMap(name="attribute-sets", entry="attribute-set", key="id", inline=true, attribute=true, required=false)
    Map<String, AttributeValueSet> attributeValueSets = Maps.newLinkedHashMap();
    @Attribute(name="default", required=false)
    String defaultAttributeValueSetId;

    public void addAttributeValueSet(String string, AttributeValueSet attributeValueSet) {
        if (this.attributeValueSets.containsKey(string)) {
            throw new IllegalArgumentException("Attribute value set with id=" + string + " already exists");
        }
        this.attributeValueSets.put(string, attributeValueSet);
    }

    public void addAttributeValueSet(String string, AttributeValueSet attributeValueSet, String string2, String string3) {
        AttributeValueSet attributeValueSet2 = new AttributeValueSet(string2, string3, attributeValueSet.baseAttributeValueSet);
        attributeValueSet2.overridenAttributeValues.putAll(attributeValueSet.overridenAttributeValues);
        this.addAttributeValueSet(string, attributeValueSet2);
    }

    public Set<String> getAttributeValueSetIds() {
        return this.attributeValueSets.keySet();
    }

    public String getDefaultAttributeValueSetId() {
        return this.defaultAttributeValueSetId;
    }

    public void setDefaultAttributeValueSetId(String string) {
        if (string != null && !this.attributeValueSets.containsKey(string)) {
            throw new IllegalArgumentException("Attribute value set with id: " + string + " does not exist.");
        }
        this.defaultAttributeValueSetId = string;
    }

    public AttributeValueSet getAttributeValueSet(String string) {
        return this.getAttributeValueSet(string, false);
    }

    public AttributeValueSet getAttributeValueSet(String string, boolean bl) {
        if (this.attributeValueSets.containsKey(string)) {
            return this.attributeValueSets.get(string);
        }
        return bl ? this.getDefaultAttributeValueSet() : null;
    }

    public AttributeValueSet getDefaultAttributeValueSet() {
        Iterator<AttributeValueSet> iterator;
        AttributeValueSet attributeValueSet = null;
        if (this.defaultAttributeValueSetId != null) {
            attributeValueSet = this.getAttributeValueSet(this.defaultAttributeValueSetId);
        }
        if (attributeValueSet == null && (iterator = this.attributeValueSets.values().iterator()).hasNext()) {
            attributeValueSet = iterator.next();
        }
        return attributeValueSet;
    }

    public void removeAttributeValueSet(String string) {
        AttributeValueSet attributeValueSet = this.attributeValueSets.get(string);
        if (attributeValueSet == null) {
            return;
        }
        this.attributeValueSets.remove(string);
        AttributeValueSet attributeValueSet2 = attributeValueSet.baseAttributeValueSet;
        for (AttributeValueSet attributeValueSet3 : this.attributeValueSets.values()) {
            attributeValueSet3.baseAttributeValueSet = attributeValueSet2;
        }
        if (string.equals(this.defaultAttributeValueSetId)) {
            this.defaultAttributeValueSetId = null;
        }
    }

    public Set<AttributeValueSet> getAttributeValueSetsBasedOn(AttributeValueSet attributeValueSet) {
        HashSet hashSet = Sets.newHashSet();
        for (AttributeValueSet attributeValueSet2 : this.attributeValueSets.values()) {
            if (attributeValueSet2.baseAttributeValueSet != attributeValueSet) continue;
            hashSet.add(attributeValueSet2);
            hashSet.addAll(this.getAttributeValueSetsBasedOn(attributeValueSet2));
        }
        return hashSet;
    }

    @Persist
    private void updateBaseAttributeValueSetIds() {
        block0: for (AttributeValueSet attributeValueSet : this.attributeValueSets.values()) {
            if (attributeValueSet.baseAttributeValueSet == null) continue;
            for (Map.Entry<String, AttributeValueSet> entry : this.attributeValueSets.entrySet()) {
                if (attributeValueSet.baseAttributeValueSet != entry.getValue()) continue;
                attributeValueSet.baseAttributeValueSetId = entry.getKey();
                continue block0;
            }
        }
    }

    @Commit
    private void restoreBaseAttributeValueSets() {
        for (AttributeValueSet attributeValueSet : this.attributeValueSets.values()) {
            attributeValueSet.baseAttributeValueSet = this.attributeValueSets.get(attributeValueSet.baseAttributeValueSetId);
        }
    }

    public void serialize(OutputStream outputStream) throws Exception {
        new Persister().write((Object)this, outputStream);
    }

    public static AttributeValueSets deserialize(InputStream inputStream) throws Exception {
        AttributeValueSets attributeValueSets = (AttributeValueSets)new Persister().read(AttributeValueSets.class, inputStream);
        AttributeValueSets.checkDefaultAttributeValueSetExists(attributeValueSets);
        return attributeValueSets;
    }

    private static void checkDefaultAttributeValueSetExists(AttributeValueSets attributeValueSets) {
        if (attributeValueSets.defaultAttributeValueSetId != null && !attributeValueSets.attributeValueSets.containsKey(attributeValueSets.defaultAttributeValueSetId)) {
            throw new RuntimeException("Default attribute value set not found: " + attributeValueSets.defaultAttributeValueSetId);
        }
    }

    public String toString() {
        return "AttributeValueSet [set IDs: " + Arrays.toString(this.getAttributeValueSetIds().toArray()) + "]";
    }
}

