/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.factory;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import org.carrot2.util.factory.IFactory;
import org.slf4j.Logger;

public final class FallbackFactory<T>
implements IFactory<T> {
    private final IFactory<T> defaultFactory;
    private final IFactory<T> fallbackFactory;
    private final String failureMessage;
    private final Logger logger;
    private final Predicate<T> verifier;

    public FallbackFactory(IFactory<T> iFactory, IFactory<T> iFactory2, Predicate<T> predicate, Logger logger, String string) {
        this.defaultFactory = iFactory;
        this.fallbackFactory = iFactory2;
        this.failureMessage = string;
        this.logger = logger;
        this.verifier = predicate;
    }

    @Override
    public final T createInstance() {
        try {
            T t = this.defaultFactory.createInstance();
            if (this.verifier.apply(t)) {
                return t;
            }
            this.logger.warn(this.failureMessage, (Object)"(false from predicate)");
            return this.fallbackFactory.createInstance();
        }
        catch (Throwable throwable) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn(this.failureMessage, (Object)(String.valueOf(throwable.toString()) + "\n" + Throwables.getStackTraceAsString((Throwable)throwable)));
            } else {
                this.logger.warn(this.failureMessage, (Object)throwable.toString());
            }
            return this.fallbackFactory.createInstance();
        }
    }
}

