/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.httpclient;

import org.apache.commons.lang.StringUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultHttpClient;

public final class HttpClientFactory {
    private static final String PROPERTY_NAME_PROXY_HOST = "http.proxyhost";
    private static final String PROPERTY_NAME_PROXY_PORT = "http.proxyport";
    public static final int DEFAULT_TIMEOUT = 8000;

    private HttpClientFactory() {
    }

    public static DefaultHttpClient getTimeoutingClient(int n) {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        HttpClientFactory.configureProxy((HttpClient)defaultHttpClient);
        defaultHttpClient.setReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
        defaultHttpClient.getParams().setIntParameter("http.socket.timeout", n);
        defaultHttpClient.getParams().setIntParameter("http.connection.timeout", n);
        defaultHttpClient.getParams().setIntParameter("http.socket.linger", 0);
        return defaultHttpClient;
    }

    private static void configureProxy(HttpClient httpClient) {
        String string = System.getProperty(PROPERTY_NAME_PROXY_HOST);
        String string2 = System.getProperty(PROPERTY_NAME_PROXY_PORT);
        if (!StringUtils.isEmpty((String)string) && !StringUtils.isEmpty((String)string2)) {
            try {
                int n = Integer.parseInt(string2);
                httpClient.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(string, n));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public static HttpClient getTimeoutingClient() {
        return HttpClientFactory.getTimeoutingClient(8000);
    }
}

